% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curl.R
\name{curl}
\alias{curl}
\title{Curl connection interface}
\usage{
curl(url = "https://hb.cran.dev/get", open = "", handle = new_handle())
}
\arguments{
\item{url}{character string. See examples.}

\item{open}{character string. How to open the connection if it should be opened
initially. Currently only "r" and "rb" are supported.}

\item{handle}{a curl handle object}
}
\description{
Drop-in replacement for base \code{\link{url}} that supports https, ftps,
gzip, deflate, etc. Default behavior is identical to \code{\link{url}}, but
request can be fully configured by passing a custom \code{\link{handle}}.
}
\details{
As of version 2.3 curl connections support \code{open(con, blocking = FALSE)}.
In this case \code{readBin} and \code{readLines} will return immediately with data
that is available without waiting. For such non-blocking connections the caller
needs to call \code{\link{isIncomplete}} to check if the download has completed
yet.
}
\examples{
\dontrun{
con <- curl("https://hb.cran.dev/get")
readLines(con)

# Auto-opened connections can be recycled
open(con, "rb")
bin <- readBin(con, raw(), 999)
close(con)
rawToChar(bin)

# HTTP error
curl("https://hb.cran.dev/status/418", "r")

# Follow redirects
readLines(curl("https://hb.cran.dev/redirect/3"))

# Error after redirect
curl("https://hb.cran.dev/redirect-to?url=https://hb.cran.dev/status/418", "r")

# Auto decompress Accept-Encoding: gzip / deflate (rfc2616 #14.3)
readLines(curl("https://hb.cran.dev/gzip"))
readLines(curl("https://hb.cran.dev/deflate"))

# Binary support
buf <- readBin(curl("https://hb.cran.dev/bytes/98765", "rb"), raw(), 1e5)
length(buf)

# Read file from disk
test <- paste0("file://", system.file("DESCRIPTION"))
readLines(curl(test))

# Other protocols
read.csv(curl("ftp://cran.r-project.org/pub/R/CRAN_mirrors.csv"))
readLines(curl("ftps://test.rebex.net:990/readme.txt"))
readLines(curl("gopher://quux.org/1"))

# Streaming data
con <- curl("http://jeroen.github.io/data/diamonds.json", "r")
while(length(x <- readLines(con, n = 5))){
  print(x)
}

# Stream large dataset over https with gzip
library(jsonlite)
con <- gzcon(curl("https://jeroen.github.io/data/nycflights13.json.gz"))
nycflights <- stream_in(con)
}

}
