% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address.R
\name{address}
\alias{address}
\title{Email Address}
\usage{
address(email = NA, display = NA, local = NA, domain = NA, normalise = TRUE)
}
\arguments{
\item{email}{Email address.}

\item{display}{Display name.}

\item{local}{Local part of email address.}

\item{domain}{Domain part of email address.}

\item{normalise}{Whether to try to normalise address to RFC-5321 requirements.}
}
\value{
An \code{address} object, representing an email address.
}
\description{
Create an \code{address} object which represents an email address.
}
\details{
Implemented as an \href{https://cran.r-project.org/package=vctrs/vignettes/s3-vector.html}{S3 vector class}.
}
\examples{
address("gerry@gmail.com")
address("gerry@gmail.com", "Gerald")
address(
  c("gerry@gmail.com", "alice@yahoo.com", "jim@aol.com"),
  c("Gerald", "Alice", NA)
)
}
