% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{text}
\alias{text}
\title{Add a text body to a message.}
\usage{
text(
  msg,
  content,
  disposition = "inline",
  charset = "utf-8",
  encoding = "7bit",
  language = FALSE,
  interpolate = TRUE,
  .open = "{{",
  .close = "}}",
  .envir = NULL
)
}
\arguments{
\item{msg}{A message object.}

\item{content}{A string of message content.}

\item{disposition}{Should the content be displayed inline or as an
attachment? Valid options are \code{"inline"} and \code{"attachment"}. If
set to \code{NA} then will guess appropriate value.}

\item{charset}{What character set is used. Most often either \code{"UTF-8"}
or \code{"ISO-8859-1"}.}

\item{encoding}{How content is transformed to ASCII. Options are
\code{"7bit"}, \code{"quoted-printable"} and \code{"base64"}. Use \code{NA}
or \code{NULL} for no (or "identity") encoding.}

\item{language}{Langauge of content. If \code{FALSE} then will not include
language field. If \code{TRUE} then will attempt to auto-detect language.
Otherwise will use the specified language.}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\value{
A message object.
}
\description{
Add \code{text/plain} content to a message.
}
\details{
The \code{text/plain} format is
described in \href{https://www.ietf.org/rfc/rfc2646.txt}{RFC 2646}.

Uses \code{glue::glue()} to evaluate expressions enclosed in brackets as R code.
}
\examples{
msg <- envelope() \%>\% text("Hello!")

# Using {glue} interpolation.
#
name <- "Alice"
msg <- envelope() \%>\% text("Hello {name}.")

print(msg, details = TRUE)

# Disable {glue} interpolation.
#
msg <- envelope() \%>\% text("This is a set: {1, 2, 3}.", interpolate = FALSE)
}
\seealso{
\code{\link{html}}, \code{\link{render}}
}
