% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tohtml.R
\name{sgr_to_html}
\alias{sgr_to_html}
\title{Convert ANSI CSI SGR Escape Sequence to HTML Equivalents}
\usage{
sgr_to_html(x, warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap"))
}
\arguments{
\item{x}{a character vector or object that can be coerced to character.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), and "truecolor" (SGR codes starting with
"38;2" or "48;2"). Changing this parameter changes how \code{fansi} interprets
escape sequences, so you should ensure that it matches your terminal
capabilities. See \link{term_cap_test} for details.}
}
\value{
a character vector with all escape sequences removed and any basic
ANSI CSI SGR escape sequences applied via SPAN html objects with
inline css styles.
}
\description{
Only the colors, background-colors, and basic styles (CSI SGR codes 1-9) are
translated.  Others are dropped silently.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.
}
\examples{
sgr_to_html("hello\\033[31;42;1mworld\\033[m")
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\code{\link[=set_knit_hooks]{set_knit_hooks()}} for how to use ANSI CSI styled text with knitr and HTML
output.
}
