% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-custom.r
\name{annotation_custom}
\alias{annotation_custom}
\title{Annotation: Custom grob.}
\usage{
annotation_custom(grob, xmin = -Inf, xmax = Inf, ymin = -Inf,
  ymax = Inf)
}
\arguments{
\item{grob}{grob to display}

\item{xmin, xmax}{x location (in data coordinates) giving horizontal
location of raster}

\item{ymin, ymax}{y location (in data coordinates) giving vertical
location of raster}
}
\description{
This is a special geom intended for use as static annotations
that are the same in every panel. These annotations will not
affect scales (i.e. the x and y axes will not grow to cover the range
of the grob, and the grob will not be modified by any ggplot settings or mappings).
}
\details{
Most useful for adding tables, inset plots, and other grid-based decorations.
}
\note{
\code{annotation_custom} expects the grob to fill the entire viewport
defined by xmin, xmax, ymin, ymax. Grobs with a different (absolute) size
will be center-justified in that region.
Inf values can be used to fill the full plot panel (see examples).
}
\examples{
# Dummy plot
df <- data.frame(x = 1:10, y = 1:10)
base <- ggplot(df, aes(x, y)) +
  geom_blank() +
  theme_bw()
# Adding a table
\dontrun{
 if (require(gridExtra)) {
base + annotation_custom(grob = tableGrob(head(iris[ ,1:3])),
        xmin = 3, xmax = 6, ymin = 2, ymax = 8)
# full panel
base + annotation_custom(grob = roundrectGrob(),
          xmin = -Inf, xmax = Inf, ymin = -Inf, ymax = Inf)
}
}
# Inset plot
df2 <- data.frame(x = 1 , y = 1)
g <- ggplotGrob(ggplot(df2, aes(x, y)) +
  geom_point() +
  theme(plot.background = element_rect(colour = "black")))
base +
  annotation_custom(grob = g, xmin = 1, xmax = 10, ymin = 8, ymax = 10)
}

