% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential.r
\name{cred_token}
\alias{cred_token}
\title{Create a new personal access token credential object}
\usage{
cred_token(token = "GITHUB_PAT")
}
\arguments{
\item{token}{The name of the environmental variable that holds the
personal access token for the authentication. Defualt is
\code{GITHUB_PAT}.}
}
\value{
A S4 \code{cred_token} object
}
\description{
The personal access token is stored in an envrionmental variable.
Environmental variables can be written to the file
\code{.Renviron}. This file is read by \emph{R} during startup,
see \code{\link[base]{Startup}}. On GitHub, personal access tokens
function like ordinary OAuth access tokens. They can be used
instead of a password for Git over HTTPS, see
\url{https://help.github.com/articles/creating-an-access-token-for-command-line-use/}
}
\examples{
\dontrun{
## Create a personal access token credential object.
## This example assumes that the token is stored in
## the 'GITHUB_PAT' environmental variable.
repo <- repository("git2r")
cred <- cred_token()
push(repo, credentials = cred)
}
}
\seealso{
Other git credential functions: \code{\link{cred_env}},
  \code{\link{cred_ssh_key}}, \code{\link{cred_user_pass}}
}
