\name{readPicture}
\alias{readPicture}
\title{ Import a Cairo SVG image }
\description{
  This function reads in an SVG image file and creates a
  \code{"Picture"} object.
}
\usage{
readPicture(file, warn = TRUE, initDefs = TRUE)
}
\arguments{
  \item{file}{ The filename of a Cairo SVG image. }
  \item{warn}{
    Logical. If \code{TRUE}, this will warn if \code{file} was not
    generated by Cairo graphics (see Details).
  }
  \item{initDefs}{
    Logical.  If \code{TRUE}, the global list of definitions (for
    things like masks, filters, gradient fills, ...) is
    initialised.
  }
}
\details{
  This function is designed to read SVG files that have been generated
  by the Cairo graphics system.

  There are several ways to generate Cairo SVG files:  The R SVG
  graphics device, provided by the \code{\link{svg}} function,
  produces Cairo SVG;  the \pkg{grConvert} package (Linux-only) can convert
  PostScript, or PDF, or SVG files to Cairo SVG;  and the
  \pkg{rsvg} package can convert many different graphics formats to
  Cairo SVG.

  It is very unlikely that an SVG file that was NOT generated by Cairo
  will import properly.  This function may read the file without error,
  but the render (via \code{\link{grid.picture}}) is very unlikely
  to faithfully reproduce the original image.
}
\value{
  An object of class \code{"Picture"}.
}
\references{
  The Cairo graphics library,  \url{https://cairographics.org/}
}
\author{ Simon Potter }
\examples{
options(warn=1)

## NOT a Cairo SVG file
badfile <- system.file("SVG", "lwd.svg", package="grImport2")
## A Cairo SVG file
goodfile <- system.file("SVG", "lwd-rsvg.svg", package="grImport2")

## Warning because NOT a Cairo SVG file
## (and it will not render correctly)
img <- readPicture(badfile)

## No warning
## (and it will render correctly)
img <- readPicture(goodfile)

if (require("rsvg")) {
    ## Generate a Cairo SVG file
    goodfile <- tempfile(fileext = ".svg")
    rsvg_svg(badfile, goodfile)

    ## No warning
    ## (and it will render correctly)
    img <- readPicture(goodfile)

}

options(warn=0)
}
