% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTableWidget.R
\name{htmlTableWidget-shiny}
\alias{htmlTableWidget-shiny}
\alias{htmlTableWidgetOutput}
\alias{renderHtmlTableWidget}
\title{Shiny bindings for htmlTableWidget}
\usage{
htmlTableWidgetOutput(outputId, width = "100\%", height = "400px")

renderHtmlTableWidget(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a htmlTableWidget}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using htmlTableWidget within Shiny
applications and interactive Rmd documents.
}
\examples{
\dontrun{
# In the UI:
htmlTableWidgetOutput("mywidget")
# In the server:
renderHtmlTableWidget({htmlTableWidget(iris)})
}
}
