% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.vsel}
\alias{summary.vsel}
\title{Summary of a \code{\link[=varsel]{varsel()}} or \code{\link[=cv_varsel]{cv_varsel()}} run}
\usage{
\method{summary}{vsel}(
  object,
  nterms_max = NULL,
  stats = "elpd",
  type = c("mean", "se", "diff", "diff.se"),
  deltas = FALSE,
  alpha = 2 * pnorm(-1),
  baseline = if (!inherits(object$refmodel, "datafit")) "ref" else "best",
  resp_oscale = TRUE,
  cumulate = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{vsel} (returned by \code{\link[=varsel]{varsel()}} or
\code{\link[=cv_varsel]{cv_varsel()}}).}

\item{nterms_max}{Maximum submodel size (number of predictor terms) for which
the performance statistics are calculated. Using \code{NULL} is effectively the
same as \code{length(ranking(object)$fulldata)}. Note that \code{nterms_max} does not
count the intercept, so use \code{nterms_max = 0} for the intercept-only model.
For \code{\link[=plot.vsel]{plot.vsel()}}, \code{nterms_max} must be at least \code{1}.}

\item{stats}{One or more character strings determining which performance
statistics (i.e., utilities or losses) to estimate based on the
observations in the evaluation (or "test") set (in case of
cross-validation, these are all observations because they are partitioned
into multiple test sets; in case of \code{\link[=varsel]{varsel()}} with \code{d_test = NULL}, these
are again all observations because the test set is the same as the training
set). Available statistics are:
\itemize{
\item \code{"elpd"}: expected log (pointwise) predictive density (for a new
dataset). Estimated by the sum of the observation-specific log predictive
density values (with each of these predictive density values being
a---possibly weighted---average across the parameter draws).
\item \code{"mlpd"}: mean log predictive density, that is, \code{"elpd"} divided by the
number of observations.
\item \code{"gmpd"}: geometric mean predictive density (GMPD), that is, \code{\link[=exp]{exp()}} of
\code{"mlpd"}. The GMPD is especially helpful for discrete response families
(because there, the GMPD is bounded by zero and one). For the corresponding
standard error, the delta method is used. The corresponding confidence
interval type is "exponentiated normal approximation" because the
confidence interval bounds are the exponentiated confidence interval bounds
of the \code{"mlpd"}.
\item \code{"mse"}: mean squared error (only available in the situations mentioned
in section "Details" below).
\item \code{"rmse"}: root mean squared error (only available in the situations
mentioned in section "Details" below). For the corresponding standard error
and lower and upper confidence interval bounds, bootstrapping is used.
\item \code{"acc"} (or its alias, \code{"pctcorr"}): classification accuracy (only
available in the situations mentioned in section "Details" below). By
"classification accuracy", we mean the proportion of correctly classified
observations. For this, the response category ("class") with highest
probability (the probabilities are model-based) is taken as the prediction
("classification") for an observation.
\item \code{"auc"}: area under the ROC curve (only available in the situations
mentioned in section "Details" below). For the corresponding standard error
and lower and upper confidence interval bounds, bootstrapping is used.
}}

\item{type}{One or more items from \code{"mean"}, \code{"se"}, \code{"lower"}, \code{"upper"},
\code{"diff"}, and \code{"diff.se"} indicating which of these to compute for each
item from \code{stats} (mean, standard error, lower and upper confidence
interval bounds, mean difference to the corresponding statistic of the
reference model, and standard error of this difference, respectively; note
that for the GMPD, \code{"diff"}, and \code{"diff.se"} actually refer to the ratio
vs. the reference model, not the difference). The confidence interval
bounds belong to normal-approximation (or bootstrap or exponentiated
normal-approximation; see argument \code{stats}) confidence intervals with
(nominal) coverage \code{1 - alpha}. Items \code{"diff"} and \code{"diff.se"} are only
supported if \code{deltas} is \code{FALSE}.}

\item{deltas}{If \code{TRUE}, the submodel statistics are estimated relatively to
the baseline model (see argument \code{baseline}). For the GMPD, the term
"relatively" refers to the ratio vs. the baseline model (i.e., the submodel
statistic divided by the baseline model statistic). For all other \code{stats},
"relatively" refers to the difference from the baseline model (i.e., the
submodel statistic minus the baseline model statistic).}

\item{alpha}{A number determining the (nominal) coverage \code{1 - alpha} of the
normal-approximation (or bootstrap or exponentiated normal-approximation;
see argument \code{stats}) confidence intervals. For example, in case of the
normal approximation, \code{alpha = 2 * pnorm(-1)} corresponds to a confidence
interval stretching by one standard error on either side of the point
estimate.}

\item{baseline}{For \code{\link[=summary.vsel]{summary.vsel()}}: Only relevant if \code{deltas} is \code{TRUE}.
For \code{\link[=plot.vsel]{plot.vsel()}}: Always relevant. Either \code{"ref"} or \code{"best"}, indicating
whether the baseline is the reference model or the best submodel found (in
terms of \code{stats[1]}), respectively.}

\item{resp_oscale}{Only relevant for the latent projection. A single logical
value indicating whether to calculate the performance statistics on the
original response scale (\code{TRUE}) or on latent scale (\code{FALSE}).}

\item{cumulate}{Passed to argument \code{cumulate} of \code{\link[=cv_proportions]{cv_proportions()}}. Affects
column \code{cv_proportions_diag} of the summary table.}

\item{...}{Arguments passed to the internal function which is used for
bootstrapping (if applicable; see argument \code{stats}). Currently, relevant
arguments are \code{B} (the number of bootstrap samples, defaulting to \code{2000})
and \code{seed} (see \code{\link[=set.seed]{set.seed()}}, but defaulting to \code{NA} so that \code{\link[=set.seed]{set.seed()}}
is not called within that function at all).}
}
\value{
An object of class \code{vselsummary}. The elements of this object are not
meant to be accessed directly but instead via helper functions
(\code{\link[=print.vselsummary]{print.vselsummary()}} and \code{\link[=performances.vselsummary]{performances.vselsummary()}}).
}
\description{
This is the \code{\link[=summary]{summary()}} method for \code{vsel} objects (returned by \code{\link[=varsel]{varsel()}} or
\code{\link[=cv_varsel]{cv_varsel()}}). Apart from some general information about the \code{\link[=varsel]{varsel()}} or
\code{\link[=cv_varsel]{cv_varsel()}} run, it shows the full-data predictor ranking, basic
information about the (CV) variability in the ranking of the predictors (if
available; inferred from \code{\link[=cv_proportions]{cv_proportions()}}), and estimates for
user-specified predictive performance statistics. For a graphical
representation, see \code{\link[=plot.vsel]{plot.vsel()}}. For extracting the predictive performance
results printed at the bottom of the output created by this \code{\link[=summary]{summary()}}
method, see \code{\link[=performances]{performances()}}.
}
\details{
The \code{stats} options \code{"mse"} and \code{"rmse"} are only available for:
\itemize{
\item the traditional projection,
\item the latent projection with \code{resp_oscale = FALSE},
\item the latent projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being \code{NULL}.
}

The \code{stats} option \code{"acc"} (= \code{"pctcorr"}) is only available for:
\itemize{
\item the \code{\link[=binomial]{binomial()}} family in case of the traditional projection,
\item all families in case of the augmented-data projection,
\item the \code{\link[=binomial]{binomial()}} family (on the original response scale) in case of the
latent projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being \code{NULL},
\item all families (on the original response scale) in case of the latent
projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being not \code{NULL}.
}

The \code{stats} option \code{"auc"} is only available for:
\itemize{
\item the \code{\link[=binomial]{binomial()}} family in case of the traditional projection,
\item the \code{\link[=binomial]{binomial()}} family (on the original response scale) in case of the
latent projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being \code{NULL}.
}
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The `stanreg` fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Run varsel() (here without cross-validation, with L1 search, and with small
# values for `nterms_max` and `nclusters_pred`, but only for the sake of
# speed in this example; this is not recommended in general):
vs <- varsel(fit, method = "L1", nterms_max = 3, nclusters_pred = 10,
             seed = 5555)
print(summary(vs), digits = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=print.vselsummary]{print.vselsummary()}}, \code{\link[=performances.vselsummary]{performances.vselsummary()}}
}
