%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  findSourceTraceback.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{findSourceTraceback}
\alias{findSourceTraceback.default}
\alias{findSourceTraceback}

\title{Finds all 'srcfile' objects generated by source() in all call frames}

\usage{
\method{findSourceTraceback}{default}(...)
}

\description{
  Finds all 'srcfile' objects generated by source() in all call frames.  This makes it possible to find out which files are
  currently scripted by \code{\link[base]{source}}().
}

\arguments{
 \item{...}{Not used.}
}

\value{
  Returns a named list of \code{\link[base]{srcfile}}() objects and/or
  \code{\link[base]{character}} strings.
  The names of the list entries corresponds to the 'filename'
  value of each corresponding 'srcfile' object.
  The returned list is empty if \code{\link[base]{source}}() was not called.
}

\examples{
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Create two R script files where one source():s the other
# and both lists the traceback of filenames source():d.
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
path <- tempdir();
pathnameA <- Arguments$getWritablePathname("foo.R", path=path);
pathnameB <- Arguments$getWritablePathname("bar.R", path=path);

code <- 'cat("BEGIN foo.R\n")';
code <- c(code, 'print(findSourceTraceback());');
code <- c(code, sprintf('source("\%s");', pathnameB));
code <- c(code, 'cat("END foo.R\n")');
code <- paste(code, collapse="\n");
cat(file=pathnameA, code);

code <- 'cat("BEGIN bar.R\n")';
code <- c(code, 'x <- findSourceTraceback();');
code <- c(code, 'print(x);');
code <- c(code, 'cat("END bar.R\n")');
code <- paste(code, collapse="\n");
cat(file=pathnameB, code);


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Source the first file
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
source(pathnameA, echo=TRUE);
}

\author{Henrik Bengtsson}

\seealso{
  See also \code{\link[utils]{sourceutils}}.
}



\keyword{IO}
\keyword{programming}
