% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{rhandsontable}
\alias{rhandsontable}
\title{Handsontable widget}
\usage{
rhandsontable(data, colHeaders, rowHeaders, comments = NULL,
  useTypes = TRUE, readOnly = NULL, selectCallback = FALSE,
  width = NULL, height = NULL, digits = 4, debug = NULL,
  search = FALSE, ...)
}
\arguments{
\item{data}{a \code{data.table}, \code{data.frame} or \code{matrix}}

\item{colHeaders}{a vector of column names. If missing \code{colnames}
will be used. Setting to \code{NULL} will omit.}

\item{rowHeaders}{a vector of row names. If missing \code{rownames}
will be used. Setting to \code{NULL} will omit.}

\item{comments}{matrix or data.frame of comments; NA values are ignored}

\item{useTypes}{logical specifying whether column classes should be mapped to
equivalent Javascript types.  Note that
Handsontable does not support column add/remove when column types
are defined (i.e. useTypes == TRUE in rhandsontable).}

\item{readOnly}{logical specifying whether the table is editable}

\item{selectCallback}{logical enabling the afterSelect event to return data.
This can be used with shiny to tie updates to a selected table cell.}

\item{width}{numeric table width}

\item{height}{numeric table height}

\item{digits}{numeric passed to \code{jsonlite::toJSON}}

\item{debug}{numeric Javascript log level}

\item{search}{logical specifying if the data can be searched (see
\url{file:///home/jonathan/Documents/git/rhandsontable/docs/index.html#customizing}
and Shiny example in inst/examples/rhandsontable_search)}

\item{...}{passed to \code{hot_table} and to the \code{params} property of the widget}
}
\description{
Create a \href{http://handsontable.com}{Handsontable.js} widget.
}
\details{
For full documentation on the package, visit \url{http://jrowen.github.io/rhandsontable/}
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF, rowHeaders = NULL)
}
\seealso{
\code{\link{hot_table}}, \code{\link{hot_cols}}, \code{\link{hot_rows}}, \code{\link{hot_cell}}
}
