% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmt.R
\name{htmt}
\alias{htmt}
\title{Assessing Discriminant Validity using Heterotrait-Monotrait Ratio}
\usage{
htmt(model, data = NULL, sample.cov = NULL, missing = "listwise",
  ordered = NULL, absolute = TRUE)
}
\arguments{
\item{model}{lavaan \link[lavaan]{model.syntax} of a confirmatory factor
analysis model where at least two factors are required for indicators
measuring the same construct.}

\item{data}{A \code{data.frame} or data \code{matrix}}

\item{sample.cov}{A covariance or correlation matrix can be used, instead of
\code{data}, to estimate the HTMT values.}

\item{missing}{If "listwise", cases with missing values are removed listwise
from the data frame. If "direct" or "ml" or "fiml" and the estimator is
maximum likelihood, an EM algorithm is used to estimate the unrestricted
covariance matrix (and mean vector). If "pairwise", pairwise deletion is
used. If "default", the value is set depending on the estimator and the
mimic option (see details in \link[lavaan]{lavCor}).}

\item{ordered}{Character vector. Only used if object is a \code{data.frame}.
Treat these variables as ordered (ordinal) variables. Importantly, all
other variables will be treated as numeric (unless \code{is.ordered} in
\code{data}). (see also \link[lavaan]{lavCor})}

\item{absolute}{logical. Whether HTMT values should be estimated based on
absolute correlations (recommended and default is \code{TRUE})}
}
\value{
A matrix showing HTMT values (i.e., discriminant validity) between
  each pair of factors
}
\description{
This function assesses discriminant validity through the
heterotrait-monotrait ratio (HTMT) of the correlations (Henseler, Ringlet &
Sarstedt, 2015). Specifically, it assesses the geometric-mean correlation
among indicators across constructs (i.e. heterotrait-heteromethod
correlations) relative to the geometric-mean correlation among indicators
within the same construct (i.e. monotrait-heteromethod correlations).
The resulting HTMT values are interpreted as estimates of inter-construct
correlations. Absolute values of the correlations are recommended to
calculate the HTMT matrix. Correlations are estimated using the
\code{\link[lavaan]{lavCor}} function in the \pkg{lavaan} package.
}
\examples{

HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '

dat <- HolzingerSwineford1939[, paste0("x", 1:9)]
htmt(HS.model, dat)

}
\references{
Henseler, J., Ringle, C. M., & Sarstedt, M. (2015). A new criterion for
  assessing discriminant validity in variance-based structural equation
  modeling. \emph{Journal of the Academy of Marketing Science, 43}(1),
  115--135. \doi{10.1007/s11747-014-0403-8}

  Voorhees, C. M., Brady, M. K., Calantone, R., & Ramirez, E. (2016).
  Discriminant validity testing in marketing: an analysis, causes for
  concern, and proposed remedies.
  \emph{Journal of the Academy of Marketing Science, 44}(1), 119--134.
  \doi{10.1007/s11747-015-0455-4}
}
\author{
Ylenio Longo (University of Nottingham; \email{yleniolongo@gmail.com})

Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})
}
