% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arith.R
\name{Ops}
\alias{Ops}
\alias{Ops.sfg}
\alias{Ops.sfc}
\title{S3 Ops Group Generic Functions for simple feature geometries}
\usage{
\method{Ops}{sfg}(e1, e2)

\method{Ops}{sfc}(e1, e2)
}
\arguments{
\item{e1}{object of class \code{sfg} or \code{sfc}}

\item{e2}{numeric, or object of class \code{sfg}; in case \code{e1} is of class \code{sfc} also an object of class \code{sfc} is allowed}
}
\value{
object of class \code{sfg}
}
\description{
S3 Ops Group Generic Functions for simple feature geometries
}
\details{
in case \code{e2} is numeric, +, -, *, /, \%\% and \%/\% add, subtract, multiply, divide, modulo, or integer-divide by \code{e2}. In case \code{e2} is an n x n matrix, * matrix-multiplies and / multiplies by its inverse. If \code{e2} is an \code{sfg} object, |, /, & and \%/\% result in the geometric union, difference, intersection and symmetric difference respectively, and \code{==} and \code{!=} return geometric (in)equality, using \link{st_equals}.

If \code{e1} is of class \code{sfc}, and \code{e2} is a length 2 numeric, then it is considered a two-dimensional point (and if needed repeated as such) only for operations \code{+} and \code{-}, in other cases the individual numbers are repeated; see commented examples.

It has been reported (https://github.com/r-spatial/sf/issues/2067) that
certain ATLAS versions result in invalid polygons, where the final point
in a ring is no longer equal to the first point. In that case, setting
the precisions with \link{st_set_precision} may help.
}
\examples{
st_point(c(1,2,3)) + 4
st_point(c(1,2,3)) * 3 + 4
m = matrix(0, 2, 2)
diag(m) = c(1, 3)
# affine:
st_point(c(1,2)) * m + c(2,5)
# world in 0-360 range:
if (require(maps, quietly = TRUE)) {
 w = st_as_sf(map('world', plot = FALSE, fill = TRUE))
 w2 = (st_geometry(w) + c(360,90)) \%\% c(360) - c(0,90)
 w3 = st_wrap_dateline(st_set_crs(w2 - c(180,0), 4326)) + c(180,0)
 plot(st_set_crs(w3, 4326), axes = TRUE)
}
(mp <- st_point(c(1,2)) + st_point(c(3,4))) # MULTIPOINT (1 2, 3 4)
mp - st_point(c(3,4)) # POINT (1 2)
opar = par(mfrow = c(2,2), mar = c(0, 0, 1, 0))
a = st_buffer(st_point(c(0,0)), 2)
b = a + c(2, 0)
p = function(m) { plot(c(a,b)); plot(eval(parse(text=m)), col=grey(.9), add = TRUE); title(m) }
o = lapply(c('a | b', 'a / b', 'a & b', 'a \%/\% b'), p)
par(opar)
sfc = st_sfc(st_point(0:1), st_point(2:3))
sfc + c(2,3) # added to EACH geometry
sfc * c(2,3) # first geometry multiplied by 2, second by 3
nc = st_transform(st_read(system.file("gpkg/nc.gpkg", package="sf")), 32119) # nc state plane, m
b = st_buffer(st_centroid(st_union(nc)), units::set_units(50, km)) # shoot a hole in nc:
plot(st_geometry(nc) / b, col = grey(.9))
}
