% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_template.R
\name{shinyAppTemplate}
\alias{shinyAppTemplate}
\title{Generate a Shiny application from a template}
\usage{
shinyAppTemplate(path = NULL, examples = "default", dryrun = FALSE)
}
\arguments{
\item{path}{Path to create new shiny application template.}

\item{examples}{Either one of "default", "ask", "all", or any combination of
"app", "rdir", "module", "shinytest", and "testthat". In an
interactive session, "default" falls back to "ask"; in a non-interactive
session, "default" falls back to "all". With "ask", this function will
prompt the user to select which template items will be added to the new app
directory. With "all", all template items will be added to the app
directory.}

\item{dryrun}{If \code{TRUE}, don't actually write any files; just print out which
files would be written.}
}
\description{
This function populates a directory with files for a Shiny application.
}
\details{
In an interactive R session, this function will, by default, prompt the user
to select which components to add to the application. Choices are\preformatted{1: All
2: app.R              : Main application file
3: R/example.R        : Helper file with R code
4: R/example-module.R : Example module
5: tests/shinytest/   : Tests using the shinytest package
6: tests/testthat/    : Tests using the testthat package
}

If option 1 is selected, the full example application including the
following files and directories is created:\preformatted{appdir/
|- app.R
|- R
|   |- example-module.R
|   `- example.R
`- tests
    |- shinytest.R
    |- shinytest
    |   `- mytest.R
    |- testthat.R
    `- testthat
        |- test-examplemodule.R
        |- test-server.R
        `- test-sort.R
}

Some notes about these files:
\itemize{
\item \code{app.R} is the main application file.
\item All files in the \verb{R/} subdirectory are automatically sourced when the
application is run.
\item \code{R/example.R} and \code{R/example-module.R} are automatically sourced when
the application is run. The first contains a function \code{lexical_sort()},
and the second contains code for module created by the
\code{\link[=moduleServer]{moduleServer()}} function, which is used in the application.
\item \verb{tests/} contains various tests for the application. You may
choose to use or remove any of them. They can be executed by the
\code{\link[=runTests]{runTests()}} function.
\item \code{tests/shinytest.R} is a test runner for test files in the
\verb{tests/shinytest/} directory.
\item \code{tests/shinytest/mytest.R} is a test that uses the
\href{https://rstudio.github.io/shinytest/}{shinytest} package to do
snapshot-based testing.
\item \code{tests/testthat.R} is a test runner for test files in the
\verb{tests/testthat/} directory using the \href{https://testthat.r-lib.org/}{testthat} package.
\item \code{tests/testthat/test-examplemodule.R} is a test for an application's module server function.
\item \code{tests/testthat/test-server.R} is a test for the application's server code
\item \code{tests/testthat/test-sort.R} is a test for a supporting function in the \verb{R/} directory.
}
}
