% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_integer.R
\name{sparse_integer}
\alias{sparse_integer}
\title{Create sparse integer vector}
\usage{
sparse_integer(values, positions, length, default = 0L)
}
\arguments{
\item{values}{integer vector, values of non-zero entries.}

\item{positions}{integer vector, indices of non-zero entries.}

\item{length}{integer value, Length of vector.}

\item{default}{integer value, value at indices not specified by \code{positions}.
Defaults to \code{0L}. Cannot be \code{NA}.}
}
\value{
sparse integer vector
}
\description{
Construction of vectors where only values and positions are recorded. The
Length and default values determine all other information.
}
\details{
\code{values} and \code{positions} are expected to be the same length, and are allowed
to both have zero length.

Allowed values for \code{value} is integer values. This means that the double
vector \code{c(1, 5, 4)} is accepted as it can be losslessly converted to the
integer vector \code{c(1L, 5L, 4L)}. Missing values such as \code{NA} and \code{NA_real_}
are allowed. Everything else is disallowed, This includes \code{Inf} and \code{NaN}.
The values are also not allowed to take the same value as \code{default}.

\code{positions} should be integers or integer-like doubles. Everything else is
not allowed. Positions should furthermore be positive (\code{0} not allowed),
unique, and in increasing order. Lastly they should all be smaller that
\code{length}.

For developers:

setting \code{options("sparsevctrs.verbose_materialize" = TRUE)} will print a
message each time a sparse vector has been forced to materialize.
}
\examples{
sparse_integer(integer(), integer(), 10)

sparse_integer(c(4, 5, 7), c(2, 5, 10), 10)

str(
  sparse_integer(c(4, 5, 7), c(2, 5, 10), 1000000000)
)
}
\seealso{
\code{\link[=sparse_double]{sparse_double()}} \code{\link[=sparse_character]{sparse_character()}}
}
