% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{update.BSpline}
\alias{update.MSpline}
\alias{update.ISpline}
\alias{update.CSpline}
\alias{update.BernsteinPoly}
\alias{update.NaturalSpline}
\alias{update.NaturalSplineK}
\title{Update Spline Basis Functions}
\usage{
\method{update}{BSpline}(object, ...)

\method{update}{MSpline}(object, ...)

\method{update}{ISpline}(object, ...)

\method{update}{CSpline}(object, ...)

\method{update}{BernsteinPoly}(object, ...)

\method{update}{NaturalSpline}(object, ...)

\method{update}{NaturalSplineK}(object, ...)
}
\arguments{
\item{object}{Spline objects produced by the \code{splines2} package.}

\item{...}{Other arguments passed to the corresponing constructor function.}
}
\value{
An updated object of the same class as the input object with the
    specified updates.
}
\description{
Update the knot placement, polynomial degree, and any other options
available when constructing the given spline object.
}
\examples{
library(splines2)

x <- seq.int(0, 1, 0.01)
knots <- c(0.3, 0.5, 0.6)

## quadratic B-splines
bsMat2 <- bSpline(x, knots = knots, degree = 2, intercept = TRUE)

## cubic B-splines
bsMat3 <- update(bsMat2, degree = 3)
}
