#include "rheolef.h"
#include "sphere.h"
using namespace std;
using namespace rheolef;
int main (int argc, char**argv) {
  geo omega (argv[1]);
  size_t d = omega.dimension();
  space Xh (omega, "P1");
  form m(Xh, Xh, "mass");
  form a(Xh, Xh, "grad_grad");
  a = a + m;
  ssk<Float> fact_a = ldlt(a.uu);
  field fh = interpolate(Xh, f(d));
  field uh(Xh);
  uh.u = fact_a.solve((m*fh).u);
  cout << setprecision(numeric_limits<Float>::digits10)
       << uh;
}
