///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
///
# include "rheolef/config.h"
#if !defined(_RHEOLEF_HAVE_SPOOLES) && !defined(_RHEOLEF_HAVE_TAUCS) && !defined(_RHEOLEF_HAVE_UMFPACK)
//
// SSK: Symmetric SKyline format
// fortran-compatible implementation
// for SPARSKIT
//
// author: Pierre.Saramito@imag.fr
//
// date: 4 september 1997
//
# include "rheolef/ssk.h"
# include "rheolef/ssk-algorithm.h"
# include "rheolef/vec.h"
# include "rheolef/permutation.h"
using namespace rheolef;
using namespace std;

template<class T>
ssk<T>::ssk ()
: _ASKY(0), _ISKY(1), _p()
{
  _ISKY (0) = 0;
}
template<class T>
ssk<T>::ssk (const csr<T>& a)
: _ASKY(0), _ISKY(a.nrow()+1), _p(gibbs(a))
{
  csr<T> a1 = perm (a,_p,_p);

  unsigned int nnzsky, nnz1;

  _csr_to_ssk_area_and_set_indexes(

    a1.ia().begin(),
    a1.ia().end(),
    a1.ja().begin(),
    _ISKY.begin(),
    nnzsky);

  _ASKY.resize(nnzsky);

  fill(_ASKY.begin(), _ASKY.end(), T(0));
  
  _csr_to_ssk_set_values(

    a1.ia().begin(),
    a1.ia().end(),
    a1.ja().begin(),
    a1.a().begin(),
    _ISKY.begin(),
    _ASKY.begin(),
    nnz1,
    int(0));
}
template<class T>
void 
ssk<T>::solve(const vec<T>& b, vec<T>& x) const
{
  trace_macro ("ssk<T>::solve...");
  ssk_solve_ldlt (_ISKY.begin(), _ASKY.begin(), 
    b.begin(), _p.begin(), x.begin(), nrow(), T(0));
  trace_macro ("ssk<T>::solve done.");
}
template <class T>
void
ssk<T>::factorize_ldlt ()
{
    ssk_factorize_ldlt (_ISKY.begin(), _ASKY.begin(), nrow(), T(0));
}    
template<class T>
ostream& 
ssk<T>::dump(ostream& s) const
{
  s << "SSK " << endl;
  s << "ISKY " << _ISKY.size() << endl;
  for (unsigned int i = 0; i < _ISKY.size(); i++)
    s << _ISKY(i) << endl;
  s << "ASKY " << _ASKY.size() << endl;
  for (unsigned int i = 0; i < _ASKY.size(); i++)
    s << _ASKY(i) << endl;
  return s;
}

// =====================[ INSTANCIATION IN LIBRARY ]=============================

template class ssk<Float>;
template ssk<Float> ldlt (const csr<Float>&);

#endif // _RHEOLEF_HAVE_SPOOLES || _RHEOLEF_HAVE_TAUCS
