/* The following code was generated by JFlex 1.4.1 on 3/15/15 1:19 AM */

/*
 * 02/05/2012
 *
 * JavaScriptTokenMaker.java - Parses a document into JavaScript tokens.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for JavaScript files.  Its states could be simplified, but are
 * kept the way they are to keep a degree of similarity (i.e. copy/paste)
 * between it and HTML/JSP/PHPTokenMaker.  This should cause no difference in
 * performance.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>JavaScriptTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.9
 */

public class JavaScriptTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int E4X = 6;
  public static final int E4X_INTAG = 10;
  public static final int E4X_PI = 8;
  public static final int JS_MLC = 3;
  public static final int JS_CHAR = 2;
  public static final int JS_EOL_COMMENT = 5;
  public static final int E4X_COMMENT = 7;
  public static final int JS_DOCCOMMENT = 4;
  public static final int E4X_DTD = 9;
  public static final int E4X_INATTR_SINGLE = 12;
  public static final int E4X_INATTR_DOUBLE = 11;
  public static final int YYINITIAL = 0;
  public static final int E4X_CDATA = 13;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\74\1\2\1\0\1\1\1\11\22\0\1\74\1\36\1\76"+
    "\1\12\1\15\1\35\1\40\1\106\2\105\1\17\1\30\1\27\1\24"+
    "\1\25\1\16\1\5\7\7\2\4\1\41\1\75\1\31\1\32\1\34"+
    "\1\37\1\45\1\102\1\6\1\100\1\101\1\23\1\22\2\3\1\111"+
    "\2\3\1\21\1\3\1\110\5\3\1\103\3\3\1\20\2\3\1\77"+
    "\1\13\1\104\1\33\1\14\1\0\1\46\1\47\1\53\1\65\1\54"+
    "\1\70\1\57\1\61\1\56\1\3\1\64\1\55\1\44\1\60\1\62"+
    "\1\66\1\73\1\52\1\50\1\51\1\10\1\71\1\63\1\72\1\67"+
    "\1\107\1\112\1\43\1\26\1\42\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\2\1\1\0\1\2\1\3\1\4\1\5\2\6"+
    "\1\5\1\2\3\7\1\5\1\10\1\5\6\7\2\2"+
    "\20\5\1\11\1\12\2\5\1\1\1\13\1\14\1\15"+
    "\1\1\1\16\1\17\1\20\1\1\1\21\5\1\1\22"+
    "\10\1\1\23\3\1\2\5\1\24\1\25\1\26\1\27"+
    "\1\1\1\30\5\1\1\31\2\1\1\32\1\1\1\33"+
    "\1\34\1\35\2\36\1\37\1\40\1\41\1\42\1\1"+
    "\1\43\3\1\1\2\1\44\1\6\1\45\1\44\1\45"+
    "\1\44\1\46\1\44\1\5\2\0\1\47\1\50\2\7"+
    "\2\0\1\51\1\7\1\52\33\5\2\53\7\5\1\53"+
    "\13\5\1\54\1\55\1\56\1\57\4\0\1\60\2\0"+
    "\1\61\32\0\1\62\1\25\1\63\1\64\1\26\5\0"+
    "\1\65\2\0\1\2\1\45\1\0\2\46\1\5\1\66"+
    "\1\67\32\5\1\70\5\5\1\71\25\5\64\0\1\72"+
    "\2\0\1\73\5\0\1\74\1\2\1\75\3\5\1\71"+
    "\3\5\1\76\6\5\1\77\1\5\1\100\24\5\1\0"+
    "\1\1\1\0\1\101\15\0\1\102\45\0\1\103\4\0"+
    "\1\104\1\0\1\105\2\0\1\106\1\0\1\107\1\2"+
    "\5\5\1\53\17\5\1\53\1\5\15\0\1\102\20\0"+
    "\1\102\20\0\1\2\4\5\1\110\13\5\33\0\10\5"+
    "\1\102\4\0\1\102\12\0\3\5\6\0\1\5\2\0"+
    "\1\111\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[620];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\113\0\226\0\341\0\u012c\0\u0177\0\u01c2\0\u020d"+
    "\0\u0258\0\u02a3\0\u02ee\0\u0339\0\u0384\0\u03cf\0\u041a\0\u0465"+
    "\0\u04b0\0\u04fb\0\u0546\0\u0591\0\u05dc\0\u04b0\0\u0627\0\u0672"+
    "\0\u06bd\0\u0708\0\u04b0\0\u04b0\0\u0753\0\u079e\0\u07e9\0\u0834"+
    "\0\u04b0\0\u087f\0\u08ca\0\u0915\0\u0960\0\u09ab\0\u09f6\0\u0a41"+
    "\0\u0a8c\0\u0ad7\0\u0b22\0\u0b6d\0\u0bb8\0\u0c03\0\u0c4e\0\u0c99"+
    "\0\u0ce4\0\u0d2f\0\u0d7a\0\u0dc5\0\u04b0\0\u04b0\0\u0e10\0\u0e5b"+
    "\0\u0ea6\0\u04b0\0\u0ef1\0\u04b0\0\u0f3c\0\u04b0\0\u0ef1\0\u04b0"+
    "\0\u0f87\0\u04b0\0\u0fd2\0\u101d\0\u1068\0\u10b3\0\u10fe\0\u04b0"+
    "\0\u1149\0\u1194\0\u11df\0\u122a\0\u1275\0\u12c0\0\u130b\0\u1356"+
    "\0\u04b0\0\u13a1\0\u13ec\0\u1437\0\u1482\0\u14cd\0\u04b0\0\u1518"+
    "\0\u1563\0\u04b0\0\u15ae\0\u04b0\0\u15f9\0\u1644\0\u168f\0\u16da"+
    "\0\u1725\0\u04b0\0\u1770\0\u17bb\0\u04b0\0\u1806\0\u04b0\0\u04b0"+
    "\0\u04b0\0\u1851\0\u189c\0\u18e7\0\u04b0\0\u04b0\0\u04b0\0\u1932"+
    "\0\u04b0\0\u197d\0\u19c8\0\u1a13\0\u1a5e\0\u1aa9\0\u1aa9\0\u1aa9"+
    "\0\u1af4\0\u1b3f\0\u1b8a\0\u1bd5\0\u1c20\0\u1c6b\0\u1cb6\0\u1d01"+
    "\0\u04b0\0\u1d4c\0\u1cb6\0\u1d97\0\u0672\0\u1d97\0\u04b0\0\u1de2"+
    "\0\u1e2d\0\u1e78\0\u1ec3\0\u1f0e\0\u1f59\0\u1fa4\0\u1fef\0\u203a"+
    "\0\u2085\0\u20d0\0\u211b\0\u2166\0\u21b1\0\u21fc\0\u2247\0\u2292"+
    "\0\u22dd\0\u2328\0\u2373\0\u23be\0\u2409\0\u2454\0\u249f\0\u24ea"+
    "\0\u2535\0\u2580\0\u25cb\0\u2616\0\u2661\0\u04fb\0\u26ac\0\u26f7"+
    "\0\u2742\0\u278d\0\u27d8\0\u2823\0\u286e\0\u28b9\0\u2904\0\u294f"+
    "\0\u299a\0\u29e5\0\u2a30\0\u2a7b\0\u2ac6\0\u2b11\0\u2b5c\0\u2ba7"+
    "\0\u2bf2\0\u04b0\0\u2c3d\0\u2c88\0\u04b0\0\u2cd3\0\u2d1e\0\u2d69"+
    "\0\u2db4\0\u04b0\0\u2dff\0\u2e4a\0\u04b0\0\u2e95\0\u2ee0\0\u2f2b"+
    "\0\u2f76\0\u2fc1\0\u300c\0\u3057\0\u30a2\0\u30ed\0\u3138\0\u3183"+
    "\0\u31ce\0\u3219\0\u3264\0\u32af\0\u32fa\0\u3345\0\u3390\0\u33db"+
    "\0\u3426\0\u3471\0\u34bc\0\u3507\0\u3552\0\u359d\0\u35e8\0\u3633"+
    "\0\u367e\0\u36c9\0\u04b0\0\u04b0\0\u3714\0\u375f\0\u37aa\0\u37f5"+
    "\0\u3840\0\u04b0\0\u388b\0\u38d6\0\u3921\0\u396c\0\u39b7\0\u1aa9"+
    "\0\u3a02\0\u3a4d\0\u3a98\0\u3ae3\0\u3b2e\0\u3b79\0\u3bc4\0\u3c0f"+
    "\0\u3c5a\0\u3ca5\0\u3cf0\0\u3d3b\0\u3d86\0\u3dd1\0\u3e1c\0\u3e67"+
    "\0\u3eb2\0\u3efd\0\u3f48\0\u3f93\0\u3fde\0\u4029\0\u4074\0\u40bf"+
    "\0\u410a\0\u4155\0\u41a0\0\u41eb\0\u4236\0\u4281\0\u04fb\0\u42cc"+
    "\0\u4317\0\u4362\0\u43ad\0\u43f8\0\u4443\0\u448e\0\u44d9\0\u4524"+
    "\0\u456f\0\u45ba\0\u4605\0\u4650\0\u469b\0\u46e6\0\u4731\0\u477c"+
    "\0\u47c7\0\u4812\0\u485d\0\u48a8\0\u48f3\0\u493e\0\u4989\0\u49d4"+
    "\0\u4a1f\0\u4a6a\0\u4ab5\0\u4b00\0\u4b4b\0\u4b96\0\u4be1\0\u4c2c"+
    "\0\u4c77\0\u4cc2\0\u4d0d\0\u4d58\0\u4da3\0\u4dee\0\u4e39\0\u4e84"+
    "\0\u4ecf\0\u4f1a\0\u4f65\0\u4fb0\0\u4ffb\0\u5046\0\u5091\0\u50dc"+
    "\0\u5127\0\u5172\0\u51bd\0\u5208\0\u5253\0\u529e\0\u52e9\0\u5334"+
    "\0\u537f\0\u53ca\0\u5415\0\u5460\0\u54ab\0\u54f6\0\u5541\0\u558c"+
    "\0\u55d7\0\u5622\0\u566d\0\u56b8\0\u5703\0\u574e\0\u5799\0\u57e4"+
    "\0\u582f\0\u587a\0\u58c5\0\u5910\0\u595b\0\u59a6\0\u59f1\0\u5a3c"+
    "\0\u5a87\0\u04b0\0\u5ad2\0\u5b1d\0\u5b68\0\u5bb3\0\u5bfe\0\u04b0"+
    "\0\u5c49\0\u04b0\0\u5c94\0\u5cdf\0\u5d2a\0\u04fb\0\u5d75\0\u5dc0"+
    "\0\u5e0b\0\u04fb\0\u5e56\0\u5ea1\0\u5eec\0\u5f37\0\u5f82\0\u5fcd"+
    "\0\u04fb\0\u6018\0\u04fb\0\u6063\0\u60ae\0\u60f9\0\u6144\0\u618f"+
    "\0\u61da\0\u6225\0\u6270\0\u62bb\0\u6306\0\u6351\0\u639c\0\u63e7"+
    "\0\u6432\0\u647d\0\u64c8\0\u6513\0\u655e\0\u65a9\0\u65f4\0\u2c88"+
    "\0\u04b0\0\u663f\0\u668a\0\u66d5\0\u6720\0\u676b\0\u67b6\0\u6801"+
    "\0\u684c\0\u6897\0\u68e2\0\u692d\0\u6978\0\u69c3\0\u6a0e\0\u6a59"+
    "\0\u04b0\0\u6aa4\0\u6aef\0\u6b3a\0\u6b85\0\u6bd0\0\u6c1b\0\u6c66"+
    "\0\u6cb1\0\u6cfc\0\u6d47\0\u6d92\0\u6ddd\0\u6e28\0\u6e73\0\u6ebe"+
    "\0\u6f09\0\u6f54\0\u6f9f\0\u6fea\0\u7035\0\u7080\0\u70cb\0\u7116"+
    "\0\u7161\0\u71ac\0\u71f7\0\u7242\0\u728d\0\u72d8\0\u7323\0\u736e"+
    "\0\u73b9\0\u7404\0\u744f\0\u749a\0\u74e5\0\u7530\0\u757b\0\u75c6"+
    "\0\u7611\0\u765c\0\u76a7\0\u76f2\0\u773d\0\u04b0\0\u7788\0\u77d3"+
    "\0\u781e\0\u7869\0\u04b0\0\u78b4\0\u78ff\0\u794a\0\u7995\0\u79e0"+
    "\0\u7a2b\0\u3eb2\0\u7a76\0\u7ac1\0\u7b0c\0\u7b57\0\u7ba2\0\u7bed"+
    "\0\u7c38\0\u7c83\0\u7cce\0\u7d19\0\u7d64\0\u7daf\0\u7dfa\0\u7e45"+
    "\0\u7e90\0\u7edb\0\u7f26\0\u668a\0\u7f71\0\u7fbc\0\u8007\0\u8052"+
    "\0\u809d\0\u80e8\0\u8133\0\u817e\0\u81c9\0\u8214\0\u825f\0\u82aa"+
    "\0\u82f5\0\u8340\0\u838b\0\u83d6\0\u8421\0\u846c\0\u84b7\0\u8502"+
    "\0\u854d\0\u8598\0\u85e3\0\u862e\0\u8679\0\u86c4\0\u870f\0\u875a"+
    "\0\u87a5\0\u87f0\0\u883b\0\u8886\0\u88d1\0\u891c\0\u8967\0\u89b2"+
    "\0\u89fd\0\u757b\0\u8a48\0\u8a93\0\u8ade\0\u76f2\0\u8b29\0\u8b74"+
    "\0\u781e\0\u8bbf\0\u8c0a\0\u8c55\0\u8ca0\0\u8ceb\0\u8d36\0\u04fb"+
    "\0\u8d81\0\u8dcc\0\u8e17\0\u8e62\0\u8ead\0\u8ef8\0\u8f43\0\u8f8e"+
    "\0\u8fd9\0\u9024\0\u906f\0\u90ba\0\u9105\0\u9150\0\u919b\0\u91e6"+
    "\0\u9231\0\u927c\0\u92c7\0\u9312\0\u935d\0\u93a8\0\u93f3\0\u943e"+
    "\0\u9489\0\u94d4\0\u951f\0\u956a\0\u95b5\0\u9600\0\u964b\0\u9696"+
    "\0\u96e1\0\u972c\0\u9777\0\u97c2\0\u980d\0\u9858\0\u98a3\0\u98ee"+
    "\0\u9939\0\u9984\0\u99cf\0\u9a1a\0\u9a65\0\u9ab0\0\u9afb\0\u9b46"+
    "\0\u9b91\0\u9bdc\0\u9c27\0\u6b3a\0\u9c72\0\u9cbd\0\u9d08\0\u9d53"+
    "\0\u9d9e\0\u9de9\0\u9e34\0\u9e7f\0\u9eca\0\u9f15\0\u9f60\0\u9fab"+
    "\0\u9ff6\0\ua041\0\ua08c\0\ua0d7\0\ua122\0\ua16d\0\ua1b8\0\ua203"+
    "\0\ua24e\0\ua299\0\u04b0\0\ua2e4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[620];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\22\1\23"+
    "\1\25\1\26\2\17\2\22\1\27\1\30\4\22\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\30\1\40"+
    "\2\30\1\41\1\42\2\41\1\43\1\22\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\1\52\1\53\1\54\1\55"+
    "\1\56\1\57\2\22\1\60\1\22\1\61\1\62\1\22"+
    "\1\63\1\64\2\22\1\20\1\34\1\65\1\33\4\22"+
    "\2\33\1\66\1\22\1\67\1\70\1\33\2\71\1\72"+
    "\10\71\1\73\62\71\1\74\14\71\2\75\1\76\10\75"+
    "\1\77\72\75\1\100\4\75\2\101\1\102\14\101\1\103"+
    "\41\101\1\104\1\101\1\105\4\101\1\106\22\101\2\107"+
    "\1\110\14\107\1\111\11\107\1\112\13\107\1\113\13\107"+
    "\1\114\1\107\1\115\4\107\1\116\21\107\1\117\2\120"+
    "\1\121\56\120\1\122\1\120\1\123\4\120\1\124\22\120"+
    "\1\125\1\126\1\127\26\125\1\130\6\125\1\131\33\125"+
    "\1\20\1\132\15\125\2\133\1\134\21\133\1\135\34\133"+
    "\1\136\1\133\1\137\4\133\1\140\22\133\2\141\1\142"+
    "\34\141\1\143\53\141\2\144\1\145\26\144\1\146\2\144"+
    "\1\147\42\144\1\150\4\144\1\151\6\144\1\152\1\153"+
    "\1\0\13\152\1\154\13\152\1\41\1\152\1\155\37\152"+
    "\1\20\1\152\1\156\7\152\1\157\4\152\76\160\1\161"+
    "\14\160\106\162\1\161\4\162\104\163\1\164\6\163\1\17"+
    "\2\0\6\17\1\0\4\17\2\0\4\17\20\0\30\17"+
    "\4\0\4\17\3\0\3\17\2\0\1\20\72\0\1\20"+
    "\131\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\166\2\0\1\166\2\23\1\166"+
    "\1\23\1\166\1\0\4\166\2\0\1\166\1\167\1\170"+
    "\1\171\1\0\1\172\16\0\10\166\1\171\1\167\7\166"+
    "\1\170\2\166\1\170\3\166\4\0\1\166\1\170\2\166"+
    "\3\0\3\166\1\0\1\166\2\0\1\166\1\173\1\174"+
    "\1\166\1\174\1\166\1\0\4\166\2\0\1\175\1\167"+
    "\1\170\1\171\1\0\1\172\16\0\10\166\1\171\1\167"+
    "\7\166\1\170\2\166\1\170\1\166\1\175\1\166\4\0"+
    "\1\166\1\170\2\166\3\0\3\166\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\12\22\1\176\13\22\4\0\4\22\3\0"+
    "\3\22\1\0\13\177\1\200\2\177\1\201\1\202\12\177"+
    "\1\203\60\177\32\0\1\41\104\0\1\41\5\0\1\41"+
    "\64\0\2\172\1\0\1\172\133\0\1\41\1\0\1\204"+
    "\111\0\1\205\1\41\61\0\1\206\27\0\1\207\1\41"+
    "\41\0\1\206\50\0\1\41\1\0\1\210\110\0\1\41"+
    "\5\0\1\41\104\0\1\41\10\0\1\41\47\0\1\17"+
    "\2\0\1\211\2\17\1\211\1\17\1\211\1\0\4\17"+
    "\2\0\4\211\20\0\1\211\1\17\26\211\4\0\4\211"+
    "\3\0\3\211\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\1\22"+
    "\1\212\24\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\4\22\1\213\7\22\1\214\4\22"+
    "\1\215\4\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\5\22\1\216\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\3\22\1\217\7\22\1\220"+
    "\1\22\1\221\3\22\1\222\4\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\4\22\1\223"+
    "\6\22\1\224\5\22\1\225\4\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\6\22\1\226"+
    "\17\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\1\227\6\22\1\230\3\22\1\231\1\232"+
    "\11\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\1\233\1\22\1\234\4\22\1\235\2\22"+
    "\1\236\10\22\1\237\1\240\1\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\6\22\1\241"+
    "\5\22\1\242\11\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\243\1\17\2\22\1\244\7\22\1\245"+
    "\7\22\1\246\3\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\14\22\1\247\11\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\5\22\1\250"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\1\251\5\22\1\252\17\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\10\22\1\253"+
    "\2\22\1\254\12\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\6\22\1\255\5\22\1\256"+
    "\11\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\5\22\1\257\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\1\260\3\22\1\261\21\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\5\22\1\262"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\1\263\6\22\1\264\1\265\3\22\1\266\11\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\1\266\13\22\1\267\11\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\1\270\25\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\12\22\1\271\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\2\71\1\0\10\71\1\0\62\71\1\0\14\71"+
    "\2\272\1\0\5\272\1\273\61\272\1\274\20\272\2\75"+
    "\1\0\10\75\1\0\72\75\1\0\4\75\2\101\1\0"+
    "\14\101\1\0\41\101\1\0\1\101\1\0\4\101\1\0"+
    "\22\101\16\0\1\275\145\0\1\276\124\0\1\277\100\0"+
    "\1\300\4\0\1\301\34\0\2\107\1\0\14\107\1\0"+
    "\11\107\1\0\13\107\1\0\13\107\1\0\1\107\1\0"+
    "\4\107\1\0\21\107\17\0\1\302\77\0\1\303\2\0"+
    "\1\303\1\0\1\303\5\0\1\304\1\0\4\303\10\0"+
    "\1\305\7\0\1\303\1\0\26\303\4\0\4\303\3\0"+
    "\3\303\45\0\1\306\1\0\1\307\1\310\1\311\1\312"+
    "\1\313\1\314\1\315\1\316\1\317\1\320\1\321\3\0"+
    "\1\322\1\323\1\324\1\0\1\325\1\326\72\0\1\327"+
    "\124\0\1\330\100\0\1\331\4\0\1\332\101\0\1\333"+
    "\45\0\2\120\1\0\56\120\1\0\1\120\1\0\4\120"+
    "\1\0\22\120\51\0\1\334\124\0\1\335\100\0\1\336"+
    "\4\0\1\337\34\0\2\125\1\0\26\125\1\0\6\125"+
    "\1\0\33\125\2\0\16\125\1\126\1\0\26\125\1\0"+
    "\6\125\1\0\33\125\1\20\1\0\15\125\3\0\1\340"+
    "\2\0\1\340\1\0\1\340\3\0\1\340\1\0\1\341"+
    "\1\0\4\340\12\0\1\342\1\343\1\0\1\340\2\0"+
    "\1\340\1\0\26\340\4\0\4\340\3\0\3\340\1\0"+
    "\74\131\1\0\1\344\15\131\2\133\1\0\21\133\1\0"+
    "\34\133\1\0\1\133\1\0\4\133\1\0\22\133\24\0"+
    "\1\345\137\0\1\346\124\0\1\347\100\0\1\350\4\0"+
    "\1\351\34\0\2\141\1\0\34\141\1\0\53\141\34\0"+
    "\1\352\56\0\2\144\1\0\26\144\1\0\2\144\1\0"+
    "\42\144\1\0\4\144\1\0\6\144\36\0\1\353\54\0"+
    "\2\152\1\0\13\152\1\0\13\152\1\0\1\152\1\0"+
    "\37\152\1\0\1\152\1\0\7\152\1\0\5\152\1\153"+
    "\1\0\13\152\1\0\13\152\1\0\1\152\1\0\37\152"+
    "\1\20\1\152\1\0\7\152\1\0\4\152\34\0\1\155"+
    "\56\0\76\160\1\0\14\160\106\162\1\0\4\162\104\163"+
    "\1\0\6\163\104\0\1\354\6\0\1\17\2\0\5\17"+
    "\1\355\1\0\4\17\2\0\4\17\20\0\30\17\4\0"+
    "\4\17\3\0\3\17\1\0\1\166\2\0\6\166\1\0"+
    "\4\166\2\0\4\166\20\0\30\166\4\0\4\166\3\0"+
    "\3\166\1\0\1\166\2\0\1\166\2\356\1\166\1\356"+
    "\1\166\1\0\4\166\2\0\4\166\1\357\3\0\1\357"+
    "\13\0\30\166\4\0\4\166\3\0\3\166\1\0\1\166"+
    "\2\0\1\166\2\172\1\166\1\172\1\166\1\0\4\166"+
    "\2\0\2\166\1\170\1\171\20\0\10\166\1\171\10\166"+
    "\1\170\2\166\1\170\3\166\4\0\1\166\1\170\2\166"+
    "\3\0\3\166\1\0\1\166\2\0\1\166\2\173\1\166"+
    "\1\173\1\166\1\0\4\166\2\0\2\166\1\170\1\171"+
    "\1\0\1\172\16\0\10\166\1\171\10\166\1\170\2\166"+
    "\1\170\3\166\4\0\1\166\1\170\2\166\3\0\3\166"+
    "\1\0\1\166\2\0\1\166\1\173\1\174\1\166\1\174"+
    "\1\166\1\0\4\166\2\0\1\166\1\360\1\170\1\171"+
    "\1\0\1\172\16\0\10\166\1\171\1\360\7\166\1\170"+
    "\2\166\1\170\3\166\4\0\1\166\1\170\2\166\3\0"+
    "\3\166\1\0\1\166\2\0\1\166\4\361\1\166\1\0"+
    "\4\166\2\0\2\166\2\361\20\0\2\166\2\361\3\166"+
    "\2\361\10\166\1\361\2\166\1\361\3\166\4\0\3\361"+
    "\1\166\3\0\3\166\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\6\22\1\362\17\22\4\0\4\22\3\0\3\22\1\0"+
    "\13\177\1\200\2\177\1\363\76\177\1\0\110\177\17\0"+
    "\1\364\74\0\1\206\27\0\1\207\42\0\1\206\50\0"+
    "\1\41\1\0\1\30\56\0\1\17\2\0\6\211\1\0"+
    "\4\17\2\0\4\211\20\0\1\211\1\17\26\211\4\0"+
    "\4\211\3\0\3\211\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\2\22\1\365\23\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\6\22\1\366\17\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\14\22\1\367\11\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\3\22\1\370\22\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\20\22\1\371\5\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\1\372\25\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\14\22"+
    "\1\373\11\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\10\22\1\374\15\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\12\22"+
    "\1\375\13\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\5\22\1\376\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\1\377\20\22\1\246\4\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\4\22\1\u0100\3\22\1\u0101\15\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\20\22"+
    "\1\u0102\5\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\3\22\1\u0103\22\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\2\22"+
    "\1\u0104\1\u0105\22\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\1\u0106\25\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\1\u0107"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\12\22\1\u0108\13\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\5\22\1\u0109"+
    "\20\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\5\22\1\u010a\20\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\2\22\1\u0104"+
    "\23\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\5\22\1\u010b\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\26\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\1\u010c\25\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\3\22\1\u010d\14\22\1\u010e\5\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\3\22\1\u010f"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\12\22\1\u0110\13\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\20\22\1\u0111"+
    "\5\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\2\22\1\u0112"+
    "\1\22\20\0\1\22\1\17\26\22\4\0\4\22\3\0"+
    "\1\22\1\u0113\1\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\2\22\1\u0114\1\u0115\22\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\3\22\1\u0116\22\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\7\22\1\u0117\16\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\3\22\1\u0118\22\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\15\22\1\246\10\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\3\22\1\u0119\22\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\10\22\1\u011a\15\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\1\22\1\u011b\5\22"+
    "\1\u011c\12\22\1\u011d\3\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\5\22\1\u011e\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\26\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\1\22\1\u011f\24\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\4\22\1\u0120\1\u0121\20\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\10\22\1\u0122\3\22\1\u0123\11\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\12\22"+
    "\1\u0124\13\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\7\22\1\u0125\16\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\14\22"+
    "\1\u0126\11\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\12\22\1\u0127\13\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\4\22"+
    "\1\246\21\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\7\22\1\u0128\1\u0129\15\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\26\22\4\0\4\22\3\0\1\22\1\246\1\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\22\22\1\u012a\3\22\4\0"+
    "\4\22\3\0\3\22\5\0\4\u012b\12\0\2\u012b\22\0"+
    "\2\u012b\3\0\2\u012b\10\0\1\u012b\2\0\1\u012b\7\0"+
    "\3\u012b\14\0\4\u012c\12\0\2\u012c\22\0\2\u012c\3\0"+
    "\2\u012c\10\0\1\u012c\2\0\1\u012c\7\0\3\u012c\61\0"+
    "\1\u012d\124\0\1\u012e\115\0\1\u012f\101\0\1\u0130\35\0"+
    "\34\303\1\305\56\303\3\0\1\303\2\0\1\303\1\0"+
    "\1\303\7\0\4\303\10\0\1\305\7\0\1\303\1\0"+
    "\26\303\4\0\4\303\3\0\3\303\55\0\1\u0131\1\0"+
    "\1\u0132\3\0\1\u0133\40\0\1\u0134\36\0\1\u0135\3\0"+
    "\1\u0136\1\0\1\u0137\117\0\1\u0138\40\0\1\u0139\40\0"+
    "\1\u013a\2\0\1\u013b\1\0\1\u013c\115\0\1\u013d\1\u013e"+
    "\4\0\1\u013f\77\0\1\u0140\104\0\1\u0141\6\0\1\u0142"+
    "\4\0\1\u0143\110\0\1\u0144\10\0\1\u0145\1\u0146\74\0"+
    "\1\u0147\1\0\1\u0148\113\0\1\u0149\1\u014a\107\0\1\u014b"+
    "\103\0\1\u014c\122\0\1\u014d\110\0\1\u014e\46\0\1\u014f"+
    "\35\0\1\u0150\3\0\1\u0151\116\0\1\u0152\102\0\1\u0153"+
    "\5\0\1\u0154\107\0\1\u0155\124\0\1\u0156\115\0\1\u0157"+
    "\101\0\1\u0158\106\0\1\u0159\3\0\1\u015a\106\0\1\u015b"+
    "\124\0\1\u015c\115\0\1\u015d\101\0\1\u015e\40\0\6\340"+
    "\3\0\1\340\3\0\6\340\13\0\1\340\2\0\1\340"+
    "\1\0\26\340\4\0\4\340\3\0\3\340\4\0\1\u015f"+
    "\2\0\1\u015f\1\0\1\u015f\3\0\1\u015f\3\0\4\u015f"+
    "\15\0\1\u015f\2\0\1\u015f\1\0\26\u015f\4\0\4\u015f"+
    "\3\0\3\u015f\25\0\1\u0160\52\0\1\u0161\47\0\1\u0162"+
    "\127\0\1\u0163\124\0\1\u0164\115\0\1\u0165\101\0\1\u0166"+
    "\61\0\1\u0167\122\0\1\u0168\56\0\1\17\2\0\1\17"+
    "\4\u0169\1\17\1\0\4\17\2\0\2\17\2\u0169\20\0"+
    "\2\17\2\u0169\3\17\2\u0169\10\17\1\u0169\2\17\1\u0169"+
    "\3\17\4\0\3\u0169\1\17\3\0\3\17\1\0\1\166"+
    "\2\0\1\166\2\356\1\166\1\356\1\166\1\0\4\166"+
    "\2\0\2\166\1\170\1\166\20\0\21\166\1\170\2\166"+
    "\1\170\3\166\4\0\1\166\1\170\2\166\3\0\3\166"+
    "\5\0\2\356\1\0\1\356\103\0\1\166\2\0\1\166"+
    "\4\361\1\166\1\0\4\166\2\0\1\166\1\360\2\361"+
    "\20\0\2\166\2\361\3\166\2\361\1\360\7\166\1\361"+
    "\2\166\1\361\3\166\4\0\3\361\1\166\3\0\3\166"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\2\22\1\234\23\22"+
    "\4\0\4\22\3\0\3\22\45\0\1\363\11\0\2\363"+
    "\51\0\1\u016a\74\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\3\22"+
    "\1\u016b\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\1\u016c\25\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\7\22\1\u016d"+
    "\16\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\6\22\1\u016e\17\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\6\22\1\266"+
    "\17\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\3\22\1\u016f\22\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\4\22\1\u0170"+
    "\21\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\3\22\1\u0105\22\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\5\22\1\u0171"+
    "\20\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\6\22\1\u0172\17\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\12\22\1\u0173"+
    "\13\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\14\22\1\u0174\11\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\2\22\1\246"+
    "\23\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\6\22\1\u0175\17\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\5\22\1\u0176\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\26\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\6\22\1\246\17\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\5\22\1\u0119\20\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\2\22\1\u0101\23\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\4\22\1\u016e\21\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\2\22\1\u0177\1\u0178\22\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\13\22\1\u0179"+
    "\12\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\1\u017a\25\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\246\1\17\26\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\7\22"+
    "\1\u017b\16\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\6\22\1\u017c\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\14\22"+
    "\1\u017d\11\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\11\22\1\u016e\14\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\7\22"+
    "\1\u017e\4\22\1\u017d\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\10\22\1\u017f\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\1\u0180\25\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\3\22\1\u0181\22\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\6\22\1\u0182\17\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\14\22\1\246\11\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\7\22\1\246\16\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\10\22\1\u0183\15\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\13\22\1\246\12\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\7\22\1\u0104\16\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\5\22\1\u0184"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\26\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\6\22\1\u0185\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\1\u0186"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\1\22\1\u0187\24\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\7\22\1\u016f"+
    "\16\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\2\22\1\u0188\23\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\16\22\1\u0189"+
    "\7\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\23\22\1\u018a\2\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\3\22\1\u018b"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\5\22\1\u018c\20\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\2\22\1\376"+
    "\23\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\1\u0170\25\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\1\u018d\25\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\1\u018e\25\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\17\22\1\246\6\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\10\22"+
    "\1\u018f\15\22\4\0\4\22\3\0\3\22\5\0\4\u0190"+
    "\12\0\2\u0190\22\0\2\u0190\3\0\2\u0190\10\0\1\u0190"+
    "\2\0\1\u0190\7\0\3\u0190\14\0\4\u0191\12\0\2\u0191"+
    "\22\0\2\u0191\3\0\2\u0191\10\0\1\u0191\2\0\1\u0191"+
    "\7\0\3\u0191\76\0\1\u0192\51\0\1\u0193\126\0\1\u0194"+
    "\125\0\1\u012f\102\0\1\u0195\4\0\1\u0196\133\0\1\u0197"+
    "\105\0\1\u0198\76\0\1\u0199\5\0\1\u019a\103\0\1\u019b"+
    "\115\0\1\u019c\115\0\1\u019d\106\0\1\u019e\104\0\1\u019f"+
    "\114\0\1\u01a0\120\0\1\u01a1\116\0\1\u01a2\104\0\1\u01a3"+
    "\3\0\1\u01a4\121\0\1\u01a5\113\0\1\u01a6\72\0\1\u01a7"+
    "\2\0\1\u01a8\21\0\1\u01a9\74\0\1\u01aa\103\0\1\u01ab"+
    "\124\0\1\u01ac\5\0\1\u01ad\34\0\1\u01ae\156\0\1\u01af"+
    "\104\0\1\u01b0\2\0\1\u01b1\14\0\1\u01b2\104\0\1\u01b3"+
    "\105\0\1\u01b4\4\0\1\u01b5\112\0\1\u01b6\102\0\1\u01b7"+
    "\7\0\1\u01b8\114\0\1\u01b9\74\0\1\u01ba\126\0\1\u01bb"+
    "\102\0\1\u01bc\15\0\1\u01bd\1\0\1\u01be\71\0\1\u01bf"+
    "\115\0\1\u01c0\116\0\1\u01c1\3\0\1\u01c2\102\0\1\u01c3"+
    "\2\0\1\u013b\107\0\1\u01c4\112\0\1\u01c5\126\0\1\u01c6"+
    "\51\0\1\u01c7\126\0\1\u01c8\125\0\1\u0157\46\0\1\u01c9"+
    "\160\0\1\u01ca\122\0\1\u01cb\51\0\1\u01cc\126\0\1\u01cd"+
    "\125\0\1\u015d\41\0\6\u015f\3\0\1\u015f\3\0\6\u015f"+
    "\13\0\1\u015f\2\0\1\u015f\1\0\26\u015f\4\0\4\u015f"+
    "\3\0\3\u015f\25\0\1\u01ce\166\0\1\u01cf\100\0\1\u01d0"+
    "\51\0\1\u01d1\126\0\1\u01d2\125\0\1\u0165\62\0\1\u01d3"+
    "\66\0\1\17\2\0\1\17\4\u01d4\1\17\1\0\4\17"+
    "\2\0\2\17\2\u01d4\20\0\2\17\2\u01d4\3\17\2\u01d4"+
    "\10\17\1\u01d4\2\17\1\u01d4\3\17\4\0\3\u01d4\1\17"+
    "\3\0\3\17\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\4\22"+
    "\1\u01d5\21\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\16\22\1\246\7\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\6\22"+
    "\1\u01d6\17\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\10\22\1\u01d7\15\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\3\22"+
    "\1\u016e\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\13\22\1\u01d8\12\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\2\22"+
    "\1\u01d9\23\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\15\22\1\u01da\10\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\14\22"+
    "\1\u01db\11\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\4\22\1\u01dc\21\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\3\22"+
    "\1\246\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\10\22\1\u01dd\15\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\20\22"+
    "\1\u01de\5\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\12\22\1\u01df\13\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\4\22"+
    "\1\u0177\21\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\6\22\1\u01e0\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\12\22"+
    "\1\u01e1\13\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\26\22\4\0\4\22\3\0\1\22"+
    "\1\u017b\1\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\1\u01e2"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\4\22\1\u01e3\21\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\23\22\1\u0104"+
    "\2\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\11\22\1\u01e4\14\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\3\22\1\u0104"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\5\22\1\u01e5\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\26\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\7\22\1\370\16\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\6\22\1\u01e6\17\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\1\u01e7\25\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\1\u0185\25\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\6\22\1\u01e8\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\3\22"+
    "\1\u01e9\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\7\22\1\u01ea\16\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\3\22"+
    "\1\254\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\12\22\1\u01eb\13\22\4\0\4\22"+
    "\3\0\3\22\42\0\1\u0194\6\0\1\u012f\45\0\6\u0193"+
    "\1\0\1\u01ec\1\0\1\u01ec\2\u0193\1\u01ec\4\u0193\2\u01ec"+
    "\1\0\2\u01ec\1\0\1\u01ec\2\0\6\u01ec\1\0\1\u0193"+
    "\1\u01ec\26\u0193\1\0\1\u01ec\1\0\1\u01ec\4\u0193\3\u01ec"+
    "\3\u0193\17\0\1\u01ed\143\0\1\u01ee\124\0\1\u01ef\105\0"+
    "\1\u01a4\1\0\1\u01f0\44\0\1\u01f1\163\0\1\u01f2\75\0"+
    "\1\u01f3\117\0\1\u01f4\115\0\1\u01f5\104\0\1\u01a4\116\0"+
    "\1\u01a3\104\0\1\u01f6\117\0\1\u01f7\114\0\1\u013b\121\0"+
    "\1\u01f8\100\0\1\u01a1\124\0\1\u01a1\104\0\1\u01f9\123\0"+
    "\1\u01fa\35\0\1\u01fb\112\0\1\u01fc\157\0\1\u01fd\105\0"+
    "\1\u01fe\112\0\1\u01ff\131\0\1\u0200\67\0\1\u01a1\126\0"+
    "\1\u0201\76\0\1\u0202\122\0\1\u0203\120\0\1\u0204\115\0"+
    "\1\u01a4\101\0\1\u0205\122\0\1\u01a1\110\0\1\u0206\101\0"+
    "\1\u0207\115\0\1\u0208\105\0\1\u0209\117\0\1\u020a\123\0"+
    "\1\u01a1\100\0\1\u01a1\111\0\1\u020b\106\0\1\u020c\121\0"+
    "\1\u01f7\103\0\1\u01ae\135\0\1\u020d\72\0\1\u020e\14\0"+
    "\1\u020f\100\0\1\u01a4\114\0\1\u0210\104\0\1\u0211\103\0"+
    "\1\u01c8\6\0\1\u0157\45\0\6\u01c7\1\0\1\u0212\1\0"+
    "\1\u0212\2\u01c7\1\u0212\4\u01c7\2\u0212\1\0\2\u0212\1\0"+
    "\1\u0212\2\0\6\u0212\1\0\1\u01c7\1\u0212\26\u01c7\1\0"+
    "\1\u0212\1\0\1\u0212\4\u01c7\3\u0212\3\u01c7\17\0\1\u0213"+
    "\145\0\1\u0214\121\0\1\u0215\73\0\1\u01cd\6\0\1\u015d"+
    "\45\0\6\u01cc\1\0\1\u0216\1\0\1\u0216\2\u01cc\1\u0216"+
    "\4\u01cc\2\u0216\1\0\2\u0216\1\0\1\u0216\2\0\6\u0216"+
    "\1\0\1\u01cc\1\u0216\26\u01cc\1\0\1\u0216\1\0\1\u0216"+
    "\4\u01cc\3\u0216\3\u01cc\17\0\1\u0217\175\0\1\u0218\52\0"+
    "\1\u01d2\6\0\1\u0165\45\0\6\u01d1\1\0\1\u0219\1\0"+
    "\1\u0219\2\u01d1\1\u0219\4\u01d1\2\u0219\1\0\2\u0219\1\0"+
    "\1\u0219\2\0\6\u0219\1\0\1\u01d1\1\u0219\26\u01d1\1\0"+
    "\1\u0219\1\0\1\u0219\4\u01d1\3\u0219\3\u01d1\17\0\1\u021a"+
    "\74\0\1\17\2\0\1\17\4\u021b\1\17\1\0\4\17"+
    "\2\0\2\17\2\u021b\20\0\2\17\2\u021b\3\17\2\u021b"+
    "\10\17\1\u021b\2\17\1\u021b\3\17\4\0\3\u021b\1\17"+
    "\3\0\3\17\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\1\u021c"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\1\u021d\25\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\5\22\1\246\20\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\4\22\1\u021e\21\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\10\22\1\u021f\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\22\22\1\246\3\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\12\22\1\u0220\13\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\12\22\1\u0221\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\6\22\1\u017b\17\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\165\2\22\2\0\4\22\20\0\1\22"+
    "\1\17\17\22\1\u0101\6\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\u0222\1\17\26\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\10\22"+
    "\1\u0223\15\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\12\22\1\u0224\13\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\22\22"+
    "\1\u0225\3\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\11\22\1\371\14\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\7\22"+
    "\1\u0177\16\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\2\22"+
    "\1\u0226\1\22\20\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\2\22\1\u0227\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\11\22\1\u0104\14\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\5\22\1\u0228\20\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\10\22\1\u0229\15\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\7\22\1\u022a\16\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\10\22\1\u022b\15\22\4\0\4\22\3\0\3\22\17\0"+
    "\1\u0193\150\0\1\u022c\120\0\1\u01bb\110\0\1\u01a1\107\0"+
    "\1\u013b\117\0\1\u0208\104\0\1\u022d\110\0\1\u022e\110\0"+
    "\1\u01a4\110\0\1\u022f\122\0\1\u01bc\117\0\1\u01a4\114\0"+
    "\1\u0230\107\0\1\u0231\102\0\1\u0232\116\0\1\u0233\103\0"+
    "\1\u0234\113\0\1\u0235\113\0\1\u0236\113\0\1\u0237\111\0"+
    "\1\u01a1\127\0\1\u01f1\76\0\1\u0238\112\0\1\u0239\120\0"+
    "\1\u023a\104\0\1\u013b\106\0\1\u013c\116\0\1\u01a1\106\0"+
    "\1\u023b\114\0\1\u023c\116\0\1\u023d\46\0\1\u023e\150\0"+
    "\1\u023f\120\0\1\u0240\112\0\1\u0241\104\0\1\u0242\122\0"+
    "\1\u0243\52\0\1\u01c7\156\0\1\u0244\114\0\1\u0245\44\0"+
    "\1\u01cc\176\0\1\u0246\26\0\1\u01d1\74\0\1\17\2\0"+
    "\1\17\4\22\1\17\1\0\4\17\2\0\2\17\2\22"+
    "\20\0\2\17\2\22\3\17\2\22\10\17\1\22\2\17"+
    "\1\22\3\17\4\0\3\22\1\17\3\0\3\17\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\5\22\1\u0177\20\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\12\22\1\u016e\13\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\14\22\1\u0247\11\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\6\22\1\u0248\17\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\5\22\1\u0104\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\6\22"+
    "\1\u0249\17\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\3\22\1\u01de\22\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\165\2\22\2\0\4\22\20\0\1\22\1\17\5\22"+
    "\1\u0102\20\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\165\2\22\2\0\4\22"+
    "\20\0\1\22\1\17\1\u024a\25\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\7\22\1\u024b"+
    "\16\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\12\22\1\u024c\13\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\3\22\1\u024d"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\14\22\1\u024e\11\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\21\22\1\246"+
    "\4\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\3\22\1\u022a\22\22\4\0\4\22\3\0"+
    "\3\22\53\0\1\u024f\120\0\1\u0239\100\0\1\u0250\116\0"+
    "\1\u0251\114\0\1\u0252\116\0\1\u0253\112\0\1\u0254\104\0"+
    "\1\u01c3\106\0\1\u0255\131\0\1\u0256\73\0\1\u01af\3\0"+
    "\1\u0257\116\0\1\u0258\114\0\1\u0209\103\0\1\u01a4\111\0"+
    "\1\u013b\117\0\1\u01a1\123\0\1\u0259\77\0\1\u025a\114\0"+
    "\1\u0201\106\0\1\u013b\114\0\1\u025b\111\0\1\u025c\111\0"+
    "\1\u0211\123\0\1\u01f0\102\0\1\u025d\40\0\26\u0245\1\u01a1"+
    "\64\u0245\103\0\1\u025e\7\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\12\22\1\u025f\13\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\12\22\1\u0177\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\12\22\1\u0260\13\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\5\22\1\u0104\20\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\14\22\1\u0261\11\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\3\22\1\u017b\22\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\165\2\22\2\0\4\22\20\0\1\22\1\17"+
    "\6\22\1\u0129\17\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\165\2\22\2\0"+
    "\4\22\20\0\1\22\1\17\12\22\1\246\13\22\4\0"+
    "\4\22\3\0\3\22\63\0\1\u0252\103\0\1\u0201\126\0"+
    "\1\u01a1\113\0\1\u01a1\77\0\1\u0251\110\0\1\u01b5\113\0"+
    "\1\u0262\46\0\1\u0263\161\0\1\u0264\101\0\1\u01a2\112\0"+
    "\1\u025b\115\0\1\u0265\112\0\1\u0251\117\0\1\u0266\136\0"+
    "\1\u0267\10\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\10\22\1\u0268"+
    "\15\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\165\2\22\2\0\4\22\20\0"+
    "\1\22\1\17\3\22\1\u0101\22\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\165"+
    "\2\22\2\0\4\22\20\0\1\22\1\17\1\u024c\25\22"+
    "\4\0\4\22\3\0\3\22\51\0\1\u01bc\115\0\1\u0269"+
    "\120\0\1\u0201\105\0\1\u01bb\104\0\1\u026a\143\0\1\u026b"+
    "\13\0\1\17\2\0\6\22\1\0\1\17\1\165\2\22"+
    "\2\0\4\22\20\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\1\u024d\2\22\52\0\1\u026c\116\0\1\u0245\105\0"+
    "\1\u01a1\11\0\1\u0208\30\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[41775];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\2\1\1\0\2\1\1\11\4\1\1\11\4\1"+
    "\2\11\4\1\1\11\23\1\2\11\3\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\5\1"+
    "\1\11\10\1\1\11\5\1\1\11\2\1\1\11\1\1"+
    "\1\11\5\1\1\11\2\1\1\11\1\1\3\11\3\1"+
    "\3\11\1\1\1\11\15\1\2\0\1\11\3\1\2\0"+
    "\1\11\62\1\1\11\2\1\1\11\4\0\1\11\2\0"+
    "\1\11\32\0\3\1\2\11\5\0\1\11\2\0\2\1"+
    "\1\0\73\1\64\0\1\1\2\0\1\11\5\0\1\11"+
    "\1\1\1\11\45\1\1\0\1\11\1\0\1\1\15\0"+
    "\1\11\45\0\1\1\4\0\1\1\1\0\1\11\2\0"+
    "\1\1\1\0\1\11\30\1\15\0\1\1\20\0\1\1"+
    "\20\0\21\1\33\0\11\1\4\0\1\1\12\0\3\1"+
    "\6\0\1\1\2\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[620];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	private static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in a JavaScript documentation comment.
	 */
	private static final int INTERNAL_IN_JS_COMMENT_DOCUMENTATION = -9;
	
	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_INVALID	= -10;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_VALID		= -11;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_INVALID	= -12;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_VALID		= -13;

	private static final int INTERNAL_E4X = -14;

	private static final int INTERNAL_E4X_INTAG = -15;

	private static final int INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION = -16;

	private static final int INTERNAL_IN_E4X_COMMENT = -17;

	private static final int INTERNAL_E4X_DTD = -18;

	private static final int INTERNAL_E4X_DTD_INTERNAL = -19;

	private static final int INTERNAL_E4X_ATTR_SINGLE = -20;

	private static final int INTERNAL_E4X_ATTR_DOUBLE = -21;

	private static final int INTERNAL_E4X_MARKUP_CDATA = -22;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;

	/**
	 * Whether we're in an internal DTD.  Only valid if in an e4x DTD.
	 */
	private boolean e4x_inInternalDtd;

	/**
	 * The previous e4x state.  Only valid if in an e4x state.
	 */
	private int e4x_prevState;

	/**
	 * The version of JavaScript being highlighted.
	 */
	private static String jsVersion;

	/**
	 * Whether e4x is being highlighted.
	 */
	private static boolean e4xSupported;

	/**
	 * Language state set on JS tokens.  Must be 0.
	 */
	private static final int LANG_INDEX_DEFAULT	= 0;

	/**
	 * Language state set on E4X tokens.
	 */
	private static final int LANG_INDEX_E4X = 1;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public JavaScriptTokenMaker() {
		super();
	}


	static {
		jsVersion = "1.7"; // Many folks using JS tend to be bleeding edge
		e4xSupported = true;
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the closest {@link TokenTypes "standard" token type} for a given
	 * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
	 */
	 @Override
	public int getClosestStandardTokenTypeForInternalType(int type) {
		switch (type) {
			case INTERNAL_IN_JS_MLC:
				return TokenTypes.COMMENT_MULTILINE;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				return TokenTypes.COMMENT_DOCUMENTATION;
			case INTERNAL_IN_JS_STRING_INVALID:
			case INTERNAL_IN_JS_STRING_VALID:
			case INTERNAL_IN_JS_CHAR_INVALID:
			case INTERNAL_IN_JS_CHAR_VALID:
				return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
		}
		return type;
	}


	/**
	 * Returns the JavaScript version being highlighted.
	 *
	 * @return Supported JavaScript version.
	 * @see #isJavaScriptCompatible(String)
	 */
	public static String getJavaScriptVersion() {
		return jsVersion;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		validJSString = true;
		e4x_prevState = YYINITIAL;
		e4x_inInternalDtd = false;
		int languageIndex = LANG_INDEX_DEFAULT;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				break;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				state = JS_DOCCOMMENT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				break;
			case INTERNAL_E4X:
				state = E4X;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_INTAG:
				state = E4X_INTAG;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION:
				state = E4X_PI;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD:
				state = E4X_DTD;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD_INTERNAL:
				state = E4X_DTD;
				e4x_inInternalDtd = true;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_SINGLE:
				state = E4X_INATTR_SINGLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_DOUBLE:
				state = E4X_INATTR_DOUBLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_CDATA:
				state = E4X_CDATA;
				languageIndex = LANG_INDEX_E4X;
				break;
			default:
				if (initialTokenType<-1024) { // INTERNAL_IN_E4X_COMMENT - prevState
					int main = -(-initialTokenType & 0xffffff00);
					switch (main) {
						default: // Should never happen
						case INTERNAL_IN_E4X_COMMENT:
							state = E4X_COMMENT;
							break;
					}
					e4x_prevState = -initialTokenType&0xff;
					languageIndex = LANG_INDEX_E4X;
				}
				else { // Shouldn't happen
					state = Token.NULL;
				}
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Returns whether e4x is being highlighted.
	 *
	 * @return Whether e4x is being highlighted.
	 * @see #setE4xSupported(boolean)
	 */
	public static boolean isE4xSupported() {
		return e4xSupported;
	}


	/**
	 * Returns whether features for a specific JS version should be honored
	 * while highlighting.
	 * 
	 * @param version JavaScript version required 
	 * @return Whether the JavaScript version is the same or greater than
	 *         version required. 
	 */
	public static boolean isJavaScriptCompatible(String version) {
		return jsVersion.compareTo(version) >= 0;
	}


	/**
	 * Sets whether e4x should be highlighted.  A repaint should be forced on
	 * all <code>RSyntaxTextArea</code>s editing JavaScript if this property
	 * is changed to see the difference.
	 *
	 * @param supported Whether e4x should be highlighted.
	 * @see #isE4xSupported()
	 */
	public static void setE4xSupported(boolean supported) {
		e4xSupported = supported;
	}


	/**
	 * Set the supported JavaScript version because some keywords were
	 * introduced on or after this version.
	 *
	 * @param javaScriptVersion The version of JavaScript to support, such as
	 *        "<code>1.5</code>" or "<code>1.6</code>".
	 * @see #isJavaScriptCompatible(String)
	 * @see #getJavaScriptVersion()
	 */
	public static void setJavaScriptVersion(String javaScriptVersion) {
		jsVersion = javaScriptVersion;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScriptTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaScriptTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 172) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 34: 
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_SINGLE);
          }
        case 74: break;
        case 33: 
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_DOUBLE);
          }
        case 75: break;
        case 36: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 76: break;
        case 72: 
          { addToken(Token.RESERVED_WORD_2);
          }
        case 77: break;
        case 26: 
          { addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
          }
        case 78: break;
        case 15: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 79: break;
        case 3: 
          { addToken(Token.WHITESPACE);
          }
        case 80: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 81: break;
        case 41: 
          { int start = zzStartRead;
										int operatorLen = yycharat(0)=='+' ? 2 : 1;
										int yylen = yylength(); // Cache before first addToken() invalidates it
										//System.out.println("'" + yytext() + "': " + yylength() + ", " + (operatorLen+1));
										addToken(zzStartRead,zzStartRead+operatorLen-1, Token.OPERATOR);
										if (yylen>operatorLen+1) {
											//System.out.println((start+operatorLen) + ", " + (zzMarkedPos-2));
											addToken(start+operatorLen,zzMarkedPos-2, Token.WHITESPACE);
										}
										zzStartRead = zzCurrentPos = zzMarkedPos = zzMarkedPos - 1;
										if (isE4xSupported()) {
											// Scanning will continue with "<" as markup tag start
											yybegin(E4X, LANG_INDEX_E4X);
										}
										// Found e4x (or syntax error) but option not enabled;
										// Scanning will continue at "<" as operator
          }
        case 82: break;
        case 64: 
          { addToken(Token.FUNCTION);
          }
        case 83: break;
        case 49: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_MARKUP); start = zzMarkedPos;
          }
        case 84: break;
        case 44: 
          { /* Skip all escaped chars. */
          }
        case 85: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 86: break;
        case 69: 
          { start = zzStartRead; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 87: break;
        case 60: 
          { int temp=zzStartRead; yybegin(E4X); addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addToken(temp,zzMarkedPos-1, Token.MARKUP_CDATA_DELIMITER);
          }
        case 88: break;
        case 58: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-2), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 89: break;
        case 46: 
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 90: break;
        case 61: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 91: break;
        case 52: 
          { start = zzMarkedPos-2; yybegin(E4X_PI);
          }
        case 92: break;
        case 35: 
          { yybegin(E4X_INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 93: break;
        case 13: 
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 94: break;
        case 19: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 95: break;
        case 23: 
          { yybegin(YYINITIAL, LANG_INDEX_DEFAULT); addToken(Token.IDENTIFIER);
          }
        case 96: break;
        case 45: 
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 97: break;
        case 71: 
          { int temp = zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_DTD); start = temp; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 98: break;
        case 63: 
          { if(e4xSupported){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 99: break;
        case 59: 
          { int temp = zzMarkedPos; addToken(start,zzStartRead+2, Token.MARKUP_COMMENT); start = temp; yybegin(e4x_prevState);
          }
        case 100: break;
        case 7: 
          { addToken(Token.OPERATOR);
          }
        case 101: break;
        case 53: 
          { yybegin(E4X); addToken(start,zzStartRead+1, Token.MARKUP_PROCESSING_INSTRUCTION);
          }
        case 102: break;
        case 48: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_DOCUMENTATION);
          }
        case 103: break;
        case 18: 
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
          }
        case 104: break;
        case 25: 
          { addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
          }
        case 105: break;
        case 5: 
          { addToken(Token.IDENTIFIER);
          }
        case 106: break;
        case 42: 
          { addToken(isE4xSupported() ? Token.MARKUP_TAG_ATTRIBUTE : Token.ERROR_IDENTIFIER);
          }
        case 107: break;
        case 68: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 108: break;
        case 55: 
          { start = zzMarkedPos-3; yybegin(JS_DOCCOMMENT);
          }
        case 109: break;
        case 9: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 110: break;
        case 51: 
          { start = zzMarkedPos-2; e4x_inInternalDtd = false; yybegin(E4X_DTD);
          }
        case 111: break;
        case 24: 
          { addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
          }
        case 112: break;
        case 10: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 113: break;
        case 28: 
          { e4x_inInternalDtd = true;
          }
        case 114: break;
        case 67: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_DOCUMENTATION); start = zzMarkedPos;
          }
        case 115: break;
        case 40: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 116: break;
        case 38: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 117: break;
        case 73: 
          { addToken(Token.MARKUP_CDATA_DELIMITER); start = zzMarkedPos; yybegin(E4X_CDATA);
          }
        case 118: break;
        case 31: 
          { addToken(Token.MARKUP_TAG_DELIMITER); /* Not valid but we'll still accept it */
          }
        case 119: break;
        case 2: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 120: break;
        case 70: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addHyperlinkToken(temp,zzMarkedPos-1, Token.MARKUP_COMMENT); start = zzMarkedPos;
          }
        case 121: break;
        case 32: 
          { yybegin(E4X); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 122: break;
        case 22: 
          { addToken(Token.MARKUP_ENTITY_REFERENCE);
          }
        case 123: break;
        case 56: 
          { if(isJavaScriptCompatible("1.7")){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 124: break;
        case 62: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 125: break;
        case 4: 
          { addNullToken(); return firstToken;
          }
        case 126: break;
        case 43: 
          { addToken(Token.RESERVED_WORD);
          }
        case 127: break;
        case 47: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 128: break;
        case 57: 
          { addToken(Token.DATA_TYPE);
          }
        case 129: break;
        case 21: 
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(E4X_INTAG);
          }
        case 130: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 131: break;
        case 30: 
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 132: break;
        case 66: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_KEYWORD); start = zzMarkedPos;
          }
        case 133: break;
        case 16: 
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 134: break;
        case 39: 
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 135: break;
        case 20: 
          { addEndToken(INTERNAL_E4X); return firstToken;
          }
        case 136: break;
        case 12: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 137: break;
        case 37: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 138: break;
        case 50: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-1), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 139: break;
        case 54: 
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 140: break;
        case 27: 
          { if (!e4x_inInternalDtd) { yybegin(E4X); addToken(start,zzStartRead, Token.MARKUP_DTD); }
          }
        case 141: break;
        case 6: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 142: break;
        case 29: 
          { e4x_inInternalDtd = false;
          }
        case 143: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 144: break;
        case 65: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 145: break;
        case 1: 
          { 
          }
        case 146: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 621: break;
            case E4X: {
              addEndToken(INTERNAL_E4X); return firstToken;
            }
            case 622: break;
            case E4X_INTAG: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_INTAG); return firstToken;
            }
            case 623: break;
            case E4X_PI: {
              addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
            }
            case 624: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 625: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 626: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 627: break;
            case E4X_COMMENT: {
              addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
            }
            case 628: break;
            case JS_DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
            }
            case 629: break;
            case E4X_DTD: {
              addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
            }
            case 630: break;
            case E4X_INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_SINGLE); return firstToken;
            }
            case 631: break;
            case E4X_INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_DOUBLE); return firstToken;
            }
            case 632: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 633: break;
            case E4X_CDATA: {
              addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addEndToken(INTERNAL_E4X_MARKUP_CDATA); return firstToken;
            }
            case 634: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
