#!/bin/bash
# bbou@ac-toulouse.fr
# 2006-08-22 11:46:28  
# _check-pam_mount.sh

### P A R A M S

if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

case ${DISTRIBUTION} in
	Redhat|Fedora|Mandriva|Suse)
		pkg="pam_mount"
		pkgs="pam_mount"
		;;
	Debian|Ubuntu)
		pkg="libpam-mount"
		pkgs="libpam-mount"
		;;
	*)
		echo "Distribution not supported"
		exit
		;;
esac

echo "+PAM_MOUNT INSTALLED PACKAGE"
for p in ${pkgs}; do
	if ${PACKAGETEST} ${p} > /dev/null; then
		[ -z "${MYVERBOSE}" ] || echo "${p} [ok]"
	else
		echo "${p} [FAIL] pam_mount not installed" >&2
		exit 1
	fi
done

echo "+PAM_MOUNT LIBRARY VERSIONS"
pammount_vers=`${PACKAGEVERSION} ${p}`
pammount_majvers=$(echo ${pammount_vers} | sed "s/\..*$//")
echo "pam_mount ${pammount_vers} (major ${pammount_majvers})"
