//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [Traj_trace] = CL__3b_traceManifolds(Traj_dir,mod,duree,MU,Traj_type)
//This function calculates all the trajectories of the manifolds defined by de Traj_dir(1:6,:)
//For each point of the orbit. The point is perturbated by mod*Traj_dir(8:13,:)
//or mod*Traj_dir(14:18,:), it depends on if it's convergent or divergent
//

//Imputs: Traj_dir:      Matrix. Dimension (19,n=number of points of the orbit)
//                        position, velocity and date,(1:7)
//                        divergent direction on position and velocity (8:13)
//                        Convergent direction on position and velocity (14:18)
//                        Traj_dir is usually generated by CL__3b_dirDirConv.sci
//          mod:          perturbation module,(POSITIF ou NEGATIF)(real)
//      duree:        Extrapolation duration for each manifold (real POSITIVE)
//          Traj_type:    0 Convergent manifold
//                        1 Divergent manifold
//
//Outputs: Traj_trace:    HyperMatrix. dimension (6,n,duree/env.pas)
//                        Represents for each point (n) position and velocity (6)
//                        during the trajectory.
//                        if a trajectory ends before the others, it is completed by NaN
//
// Author:
// A. BLAZQUEZ (CNES DCT/SB/MO)

// Declarations:


// Code:

sizeTd = size(Traj_dir);

i = 1;
j = 1;

//Initialisation (convergent or divergent)
if Traj_type==0
  X0 = Traj_dir(1:6,i) + mod*Traj_dir(8:13,i);
  duree = abs(duree);
  f=CL__3b_RHS
else
  duree = -abs(duree);
  X0 = Traj_dir(1:6,i) + mod*Traj_dir(14:19,i);
  f=CL__3b_RHSReb
end

tinit = Traj_dir(7,i);
[X,t] = CL__3b_integratorVar(X0,tinit,duree,f,MU);

sx = size(X);
Traj_trace = hypermat([6,sx(2),1]);
Traj_trace(:,:,1) = X;

i =i+1;
j =j+1;


// loop for each point of Traj_dir

while i < sizeTd(2)
  if Traj_type==0
    X0 = Traj_dir(1:6,i) + mod*Traj_dir(8:13,i);
  else
    X0 = Traj_dir(1:6,i) + mod*Traj_dir(14:19,i);
  end

  tinit = Traj_dir(7,i);
  [X,t] = CL__3b_integratorVar(X0,tinit,duree,f,MU);

// Plot for testing
// plot(X(1,:),X(2,:),'k');

  strace = size(Traj_trace);
  sx = size(X);
  Traj_tracestock = Traj_trace;
  if (strace(2) < sx(2))
    Traj_trace = hypermat([6,sx(2),j]);
    Traj_trace(:,1:strace(2),1:j-1) = Traj_tracestock;
    Traj_trace(:,strace(2)+1:sx(2),1:j-1) = ones((j-1)*6*(sx(2)-strace(2)))*%nan;
    Traj_trace(:,:,j) = X;
  else
    Traj_trace = hypermat([6,strace(2),j]);
    Traj_trace(:,:,1:j-1) = Traj_tracestock;
    Traj_trace(:,:,j) = [X %nan*ones(6,strace(2)-sx(2))];
  end

  i = i+1;
  j = j+1;

end

endfunction
