# Release Notes v0.9.2 : Preprocessing and MOCUS Optimizations

This micro release polishes the fault tree preprocessing techniques
and optimizes minimal cut set generation.


## Major Changes

- Performance optimization with hash tables and flat sets for MOCUS
  (2x - 20x speed improvement and 5x - 10x better  memory utilization)

- Merging common arguments of gates for non-coherent fault trees

- Heuristics for substitution of common arguments by existing gates
  (Merging common arguments runs 3x-4x faster
   but results in ~10% performance hit for cut set generation in some cases)

- Heuristics for reduction of the number of parents of common arguments
  (Modularity is favored in merging common arguments)

- Multiple gate definition detection with hash tables
  (Linear complexity and 10x-100x speed improvement for the detection)

- Better strategy for handling distributive setups
  (10% - 20% cut-set-generation improvement for some cases)

- The Shannon decomposition of common nodes with less gate cloning
  (Makes possible to preprocess graphs with 1000s of nodes without blowup)


## Bug Fixes

- Mishandling of duplicate arguments in K/N gate preprocessing

- Handling of distributive setups introduces
  unmanageable subgraphs for other preprocessing and analysis steps.
  (Graph visit marks are messed up)

- Incorrect assumption in common argument merging
  that if set A of common arguments is a subset of set B,
  group A of gates is a superset of group B.

- Failing to properly unset module flags of gates
  in propagation of complements.
  The problem manifests itself upon creation of clones.


## Since v0.9.1

- 71 commits resulted in
  46 files changed, 2673 insertions(+), 1893 deletions(-)
