/* Copyright (c) 2017. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#ifndef XBT_FILE_HPP
#define XBT_FILE_HPP

#include <string>
#include <xbt/base.h>

namespace simgrid {
namespace xbt {

class Path {
public:
  explicit Path(const char* path): path_(path) {}
  explicit Path(std::string path): path_(std::move(path)) {}

  /** @brief Returns the full path name */
  std::string getName() { return path_; }
  /** @brief Returns the directory component of a path (reimplementation of POSIX dirname) */
  std::string getDirname();
  /** @brief Returns the file component of a path (reimplementation of POSIX basename) */
  std::string getBasename();

private:
  std::string path_;
};
}}

#endif                          /* XBT_FILE_HPP */
