/*
 * Copyright (c) 2007, Sun Microsystems, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *     * Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *
 *     * Neither the name of Sun Microsystems, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package javanet.staxutils;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

import javax.xml.stream.XMLStreamException;
import java.io.StringReader;

/**
 * This class tests StAXSource
 *
 * @author Ryan.Shoemaker@Sun.COM
 * @version $Revision: 1.1 $
 * @since 1.0
 */
public class StAXSourceTest extends StAXTestCase {

    public void testGetFeature() throws XMLStreamException {
        boolean pass = true;
        StAXSource staxSource =
                new StAXSource(inputFactory.createXMLStreamReader(new StringReader("<foo/>")));
        XMLReader r = staxSource.getXMLReader();
        try {
            assertTrue(
                    r.getFeature("http://xml.org/sax/features/namespaces") &&
                    r.getFeature("http://xml.org/sax/features/external-general-entities") &&
                    r.getFeature("http://xml.org/sax/features/external-parameter-entities"));
        } catch (SAXException e) {
            pass = false;
            e.printStackTrace();
        } finally {
            if(!pass) {
                fail();
            }
        }
    }

    public void testGetFeatureNegative() throws XMLStreamException {
        boolean pass = false;
        StAXSource staxSource =
                new StAXSource(inputFactory.createXMLStreamReader(new StringReader("<foo/>")));
        XMLReader r = staxSource.getXMLReader();
        try {
            r.getFeature("http://foo.blarg.com");
        } catch (SAXException e) {
            pass = true;
        } finally {
            if(!pass) {
                fail();
            }
        }
    }

    public void testSetFeaturePositive() throws XMLStreamException {
        boolean pass = true;
        StAXSource staxSource =
                new StAXSource(inputFactory.createXMLStreamReader(new StringReader("<foo/>")));
        XMLReader r = staxSource.getXMLReader();
        try {
            r.setFeature("http://xml.org/sax/features/namespaces", true);
            r.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            r.setFeature("http://xml.org/sax/features/external-general-entities", true);
            r.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
        } catch (SAXException e) {
            pass = false;
            e.printStackTrace();
        } finally {
            if(!pass) {
                fail();
            }
        }
    }

    public void testSetFeatureNegative() throws XMLStreamException {
        boolean pass = false;
        StAXSource staxSource =
                new StAXSource(inputFactory.createXMLStreamReader(new StringReader("<foo/>")));
        XMLReader r = staxSource.getXMLReader();
        try {
            r.setFeature("http://xml.org/sax/features/namespaces", false);
        } catch (SAXException e) {
            pass = true;
        } finally {
            if(!pass) {
                fail();
            }
        }
    }

}
