/********************************************************************************
 * Copyright (c) 2020 Equo
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Guillermo Zunino, Equo - initial implementation
 ********************************************************************************/
/* automatically generated by rust-bindgen */

#![allow(dead_code)]
#![allow(non_snake_case)]
#![allow(non_camel_case_types)]
#![allow(non_upper_case_globals)]

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _XDisplay {
    _unused: [u8; 0],
}
pub type XDisplay = _XDisplay;
extern "C" {
    ///
    /// Return the singleton X11 display shared with Chromium. The display is not
    /// thread-safe and must only be accessed on the browser process UI thread.
    ///
    pub fn cef_get_xdisplay() -> *mut XDisplay;
}
///
/// Structure representing CefExecuteProcess arguments.
///
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_main_args_t {
    pub argc: ::std::os::raw::c_int,
    pub argv: *mut *mut ::std::os::raw::c_char,
}
///
/// Class representing window information.
///
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_window_info_t {
    pub x: ::std::os::raw::c_uint,
    pub y: ::std::os::raw::c_uint,
    pub width: ::std::os::raw::c_uint,
    pub height: ::std::os::raw::c_uint,
    ///
    /// Pointer for the parent window.
    ///
    pub parent_window: ::std::os::raw::c_ulong,
    ///
    /// Set to true (1) to create the browser using windowless (off-screen)
    /// rendering. No window will be created for the browser and all rendering will
    /// occur via the CefRenderHandler interface. The |parent_window| value will be
    /// used to identify monitor info and to act as the parent window for dialogs,
    /// context menus, etc. If |parent_window| is not provided then the main screen
    /// monitor will be used and some functionality that requires a parent window
    /// may not function correctly. In order to create windowless browsers the
    /// CefSettings.windowless_rendering_enabled value must be set to true.
    /// Transparent painting is enabled by default but can be disabled by setting
    /// CefBrowserSettings.background_color to an opaque value.
    ///
    pub windowless_rendering_enabled: ::std::os::raw::c_int,
    ///
    /// Pointer for the new browser window. Only used with windowed rendering.
    ///
    pub window: ::std::os::raw::c_ulong,
}
