C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                     SUBROUTINE RRAYRC
C                    *****************
C
C     ----------------------------------------------------
     *( FDFRAY,SUFRAY,NELRAY,EMISSI,RADIOS,EPROPR,NUMBS,
     *  X,B,XM1,GD,RES,Z,DI,RESM1)
C      ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     SOLVEUR D'UN SYSTEME   A X = B                    *
C                                                                      *
C      Ce sous-programme determine la solution de:                     *
C                                                                      *
C                         A X = B                                      *
C                                                                      *
C      A est une matrice symetrique.                                   *
C      On utilise la methode du gradient conjuge, et le                *
C      preconditionnement par la diagonale.                            *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   X       !  TR  ! M  ! VECTEUR RESULTAT                         !
C   !   B       !  TR  ! D  ! SECOND MEMBRE DE L'EQUATION              !
C   !   DI      !  TR  ! M  ! Diagonale de la matrice                  !
C   !   RES     !  TR  ! M  ! RESIDU                                   !
C   !   GD      !  TR  ! M  ! GRADIENT DE DESCENTE                     !
C   !   Z       !  TR  ! M  ! VECTEUR CONTENANT 'M' MULTIPLIEE PAR DD  !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : OV,PROSCA
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NELRAY,NUMBS
C
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION SUFRAY(NELRAY),EMISSI(NELRAY,2,NBANDE)
      DOUBLE PRECISION RADIOS(NELRAY,NBANDE),EPROPR(NELRAY,NBANDE)
      DOUBLE PRECISION X(NELRAY),B(NELRAY),GD(NELRAY)
      DOUBLE PRECISION RES(NELRAY),Z(NELRAY),DI(NELRAY)
C
      DOUBLE PRECISION XM1(NELRAY),RESM1(NELRAY)
C 
C..Variables locales
      DOUBLE PRECISION AA,BB,CC,D,EE,ALFA,AALFA,TAU,ALFAM1,ALFTAU
      DOUBLE PRECISION AUX1,AUX2,AUX,DENOM

      INTEGER N,I,J,NITSMO
      DOUBLE PRECISION X0,RESNOR,PRSCA1
      DOUBLE PRECISION EPSIS,ZERO,EPSSMO
C      
C***********************************************************************
C    
C     1- INITIALISATION
C     =================
C
      ZERO   = 0.D0
      NITSMO = 100
      EPSSMO = 1.E-12
      NFECRA = 6
      N = 0
C 
C     1- INITIALISATION DES VECTEURS AUXILIAIRES
C     ========================================== 
        DO 10 I=1,NELRAY
          B(I)  = EPROPR(I,NUMBS)
          DI(I) = SUFRAY(I)-EMISSI(I,2,NUMBS)
     &                  *FDFRAY((I-1)*NELRAY-(I-3)*I/2)            
          X(I) = EPROPR(I,NUMBS)
          XM1(I) = EPROPR(I,NUMBS)
   10   CONTINUE
C

C     Norme du second membre 
C     ----------------------
      CALL PROSCA ( NELRAY,X,X,PRSCA1 )
      X0 = SQRT ( PRSCA1 )
C  
      IF ( X0 .LT. 1.D-20 ) X0 = 1.D-6
      EPSIS = 1.D-4 * X0
C
      DO 100 I=1,NELRAY
        RES(I) = 0.
        DO 110 J=1,I-1
           RES(I) = RES(I) -  FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)  
     &           * EMISSI(I,2,NUMBS)
     &           * X(J)
 110    CONTINUE
        DO 120 J=I+1,NELRAY
           RES(I) = RES(I) -   FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)
     &           * EMISSI(I,2,NUMBS)
     &           * X(J)
 120    CONTINUE
        RES(I) = RES(I) + DI(I)*X(I) - B(I)
 100  CONTINUE
C
      CALL PROSCA ( NELRAY,RES,RES,PRSCA1 )
      RESNOR = SQRT ( PRSCA1 )
C
      IF ( RESNOR.LE.EPSIS .AND.  RESNOR.LE.EPSGCS*SQRT(DBLE(NELRAY)))
     & THEN
C
C         Affichage de la precision relative et absolue et sortie
C         -------------------------------------------------------
          IF (NBLBLR.GE.2) THEN
            WRITE(NFECRA,1000)
            WRITE(NFECRA,1010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))
          ELSEIF (NBLBLR.GT.0) THEN
            WRITE(NFECRA,2010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))
          ENDIF
          RETURN
C
      ENDIF
C
C     2. PROCESSUS ITERATIF
C     =====================
      IF (NBLBLR.GE.2) WRITE(NFECRA,1000)
      DO 198 I=1,NELRAY
         RESM1(I) = RES(I)
 198  CONTINUE
C
    1 N = N + 1
C
      DO 199 I=1,NELRAY
         GD(I) = RES(I)/DI(I)
 199  CONTINUE
C
      DO 200 I=1,NELRAY
        Z(I) = 0.
        DO 210 J=1,I-1
           Z(I) = Z(I) -  FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)  
     &           * EMISSI(I,2,NUMBS)
     &           * GD(J)
 210    CONTINUE
        DO 220 J=I+1,NELRAY
           Z(I) = Z(I) -   FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)
     &           * EMISSI(I,2,NUMBS)
     &           * GD(J)
 220    CONTINUE
        Z(I) = Z(I) + DI(I)*GD(I)
 200  CONTINUE
C
      AA = 0.
      BB = 0.
      CC = 0.
      D  = 0.
      EE = 0.
      DO 31 I=1,NELRAY
         AA = AA + Z(I)*RES(I)
         BB = BB + Z(I)*RESM1(I)
         AUX = RES(I)-RESM1(I)
         CC = CC +RES(I)*AUX
         D  = D  +RESM1(I)*AUX
         EE = EE +Z(I)*Z(I)
   31 CONTINUE
C
      DENOM = (CC-D )*EE-(AA-BB)*(AA-BB)
      IF(ABS(DENOM) .LT. 1E-20) THEN
         ALFA = 1.
      ELSE
         ALFA = ((AA-BB)*BB-D *EE)/DENOM
      ENDIF
C
      AALFA = ABS(ALFA)
      IF (AALFA .LE. 1E-20 .OR. ABS(AALFA-1.) .LE. 1.E-20) THEN
         ALFA = 1.
         TAU = AA/EE
      ELSE
         TAU = AA/EE + (1.-ALFA)/ALFA * BB/EE
      ENDIF
C
      ALFAM1  = 1.-ALFA
      ALFTAU  = -ALFA*TAU
      DO 300 I=1,NELRAY
        AUX1     = RES(I)
        AUX2     = X(I)
        RES(I)   = ALFA*AUX1+ALFAM1*RESM1(I)+ALFTAU*Z(I)
        RESM1(I) = AUX1
        X(I)     = ALFA*AUX2+ALFAM1*XM1(I)+ALFTAU*GD(I)
        XM1(I)   = AUX2
  300 CONTINUE
C
C
      CALL PROSCA ( NELRAY,RES,RES,PRSCA1 ) 
      RESNOR = SQRT ( PRSCA1 )
C
      IF (NBLBLR.GE.2 .AND. MOD(N,10).EQ.0)
     &    WRITE(NFECRA,1010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))

      IF ( .NOT. ( (RESNOR.LE.EPSIS .AND.  
     &              RESNOR.LE.EPSGCS*SQRT(DBLE(NELRAY)))
     &                  .OR.  N.GE.NITSMO ) )  
     &    GOTO 1
C
      IF (NBLBLR.GT.0)
     &  WRITE (NFECRA,2010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))
C
C
C     4. REMISE A JOUR DU VECTEUR
C     ===========================
      DO 400 I=1,NELRAY
         RADIOS(I,NUMBS) = X(I)
  400 CONTINUE
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT (/,' *** RRAYRC: RESOLUTION DU RAYONNEMENT'
     &       ,/,10X,' ITERATIONS   PRECISION RELATIVE',  
     &       '   PRECISION ABSOLUE')
 1010 FORMAT (13X,I4,11X,E12.5,6X,E12.5)  
 2010 FORMAT (' RRAYRC',I4,' ITERATIONS    PRECISION RELATIVE = ',E12.5,
     &          ' PRECISION ABSOLUE = ', E12.5 )
C
      END    





