C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                          ****************                           
                           SUBROUTINE WHISOL
C                          *****************
C
C     ----------------------------------------------
     *(NDIM,NPOINS,COORDS,TMPSA,TMPS)
C     ----------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C  FONCTION :
C  ---------
C
C     ECRITURE DES HISTORIQUES EN TEMPS SUR LE SOLIDE
C
C-----------------------------------------------------------------------
C               (*)   (*)     ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME (2 OU 3)              !
C   ! NPOINS !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                !
C   ! NBHSOL !   E  ! D  ! NOMBRE DE NOEUDS AVEC HISTORIQUE            !
C   ! NHISOL !  TE  ! D  ! NUMEROS DES NOEUDS AVEC HISTORIQUE          !
C   ! TMPS   !  TR  ! D  ! TEMPERATURE DANS LE SOLIDE ETAPE n+1        !
C   ! TMPSA  !  TR  ! D  ! TEMPERATURE DANS LE SOLIDE ETAPE n          !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/HISSOL/!      ! D  !                                             !
C   !/NLOFIC/!      ! D  !                                             !
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ------
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : RESSOL
C
C*************************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON
C **********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C
C...  Declaration des variables externes
C 
      INTEGER NDIM,NPOINS
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
      DOUBLE PRECISION TMPS(NPOINS),TMPSA(NPOINS)
C
C...  Declaration des variables internes
C
      INTEGER N,NUM
C
C
C***********************************************************************
C
C     ----------------------
C     1- CAS DU MODELE COQUE
C     ----------------------
C
      IF (NCTHFS.EQ.2) THEN
C
        DO 10 N=1,NBHSOL
          NUM = NHISOL(N)
          WRITE(NFHRCT,1000) TEMPSS,NUM,
     &                       COORDS(NUM,1),COORDS(NUM,2),COORDS(NUM,3),
     &                       TMPSA(NUM),TMPS(NUM)
   10   CONTINUE
        CALL FLUSHF(NFHRCT)
C
C
C     ------------------------------
C     2- CAS DU MODELE GENERAL EN 2D
C     ------------------------------
C
      ELSEIF (NCTHFS.EQ.3 .AND. NDIM.EQ.2) THEN
C
        DO 20 N=1,NBHSOL
          NUM = NHISOL(N)
          WRITE(NFHRCT,2000) TEMPSS,NUM,
     &                       COORDS(NUM,1),COORDS(NUM,2),
     &                       TMPS(NUM)
   20   CONTINUE
        CALL FLUSHF(NFHRCT)
C
C     ------------------------------
C     2- CAS DU MODELE GENERAL EN 3D
C     ------------------------------
C
      ELSEIF (NCTHFS.EQ.3 .AND. NDIM.EQ.3) THEN
C
        DO 30 N=1,NBHSOL
          NUM = NHISOL(N)
          WRITE(NFHRCT,3000) TEMPSS,NUM,
     &                       COORDS(NUM,1),COORDS(NUM,2),COORDS(NUM,3),
     &                       TMPS(NUM)
   30   CONTINUE
        CALL FLUSHF(NFHRCT)
C
C
      ENDIF
C
C
C-------
C FORMAT
C-------
C
 1000 FORMAT ( 1X,E15.9,1X,I6,5(1X,E15.9))
 2000 FORMAT ( 1X,E15.9,1X,I6,3(1X,E15.9))
 3000 FORMAT ( 1X,E15.9,1X,I6,4(1X,E15.9))
C
C----
C FIN
C----
C
      RETURN
      END
